/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus.types;

import java.math.BigInteger;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.StringUtils;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.api.cygnus.ICygnusStack;
import quaternary.incorporeal.cygnus.CygnusError;

public class CygnusBigIntegerType
implements ICygnusDatatype<BigInteger> {
    private static final BigInteger topCap = new BigInteger("+" + StringUtils.repeat((char)'9', (int)50), 10);
    private static final BigInteger bottomCap = new BigInteger("-" + StringUtils.repeat((char)'9', (int)50), 10);
    private static final String TOO_SMALL_NUMBER = "incorporeal.cygnus.error.invalid_math.too_small";
    private static final String TOO_BIG_NUMBER = "incorporeal.cygnus.error.invalid_math.too_big";
    private static final BigInteger FIFTEEN = BigInteger.valueOf(15L);

    @Override
    public Class<BigInteger> getTypeClass() {
        return BigInteger.class;
    }

    @Override
    public String getTranslationKey() {
        return "incorporeal.cygnus.type.number";
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, BigInteger item) {
        nbt.func_74773_a("BigInt", item.toByteArray());
    }

    @Override
    public BigInteger readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("BigInt", 9)) {
            NBTTagList list = nbt.func_150295_c("BigInt", 3);
            if (list.func_74745_c() == 0) {
                return BigInteger.ZERO;
            }
            byte[] bytes = new byte[list.func_74745_c()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)list.func_186858_c(i);
            }
            return new BigInteger(bytes);
        }
        return new BigInteger(nbt.func_74770_j("BigInt"));
    }

    @Override
    public void writeToPacketBuffer(PacketBuffer buf, BigInteger item) {
        byte[] bytes = item.toByteArray();
        buf.func_179250_a(bytes);
    }

    @Override
    public BigInteger readFromPacketBuffer(PacketBuffer buf) {
        return new BigInteger(buf.func_189425_b(1000000));
    }

    @Override
    @Nullable
    public Object getError(BigInteger item, ICygnusStack stack) {
        if (item.compareTo(bottomCap) < 0) {
            return new CygnusError("incorporeal.cygnus.error.invalid_math", TOO_SMALL_NUMBER);
        }
        if (item.compareTo(topCap) > 0) {
            return new CygnusError("incorporeal.cygnus.error.invalid_math", TOO_BIG_NUMBER);
        }
        return null;
    }

    @Override
    public boolean areEqual(BigInteger item1, BigInteger item2) {
        return item1.equals(item2);
    }

    @Override
    public int compare(BigInteger item1, BigInteger item2) {
        return item1.compareTo(item2);
    }

    @Override
    public int toComparator(BigInteger item) {
        if (item.compareTo(BigInteger.ONE) < 0) {
            return 1;
        }
        if (item.compareTo(FIFTEEN) > 0) {
            return 15;
        }
        return item.intValue();
    }
}

