/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus.cap;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import quaternary.incorporeal.api.cygnus.ICygnusFunnelable;
import quaternary.incorporeal.cygnus.cap.IncorporeticCygnusCapabilities;
import quaternary.incorporeal.etc.helper.CorporeaHelper2;
import quaternary.incorporeal.item.cygnus.ItemCygnusTicket;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaFunnel;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.corporea.TileCorporeaRetainer;

@Mod.EventBusSubscriber
public class AttachCapabilitiesEventHandler {
    public static final ResourceLocation FUNNEL_HANDLER = new ResourceLocation("incorporeal", "cygnus_funnel_handler");

    @SubscribeEvent
    public static void attachTileCapabilities(AttachCapabilitiesEvent<TileEntity> e) {
        TileEntity tile = (TileEntity)e.getObject();
        if (tile instanceof TileCorporeaRetainer) {
            e.addCapability(FUNNEL_HANDLER, new GenericCapabilityProvider<CorporeaRetainerFunnelable>(IncorporeticCygnusCapabilities.FUNNEL_CAP, new CorporeaRetainerFunnelable((TileCorporeaRetainer)tile)));
        } else if (tile instanceof TileCorporeaCrystalCube) {
            e.addCapability(FUNNEL_HANDLER, new GenericCapabilityProvider<CorporeaCrystalCubeFunnelable>(IncorporeticCygnusCapabilities.FUNNEL_CAP, new CorporeaCrystalCubeFunnelable((TileCorporeaCrystalCube)tile)));
        } else if (tile instanceof TileCorporeaFunnel) {
            e.addCapability(FUNNEL_HANDLER, new GenericCapabilityProvider<CorporeaRequesterFunnelable<TileCorporeaFunnel>>(IncorporeticCygnusCapabilities.FUNNEL_CAP, new CorporeaRequesterFunnelable<TileCorporeaFunnel>((TileCorporeaFunnel)tile)));
        } else if (tile instanceof TileCorporeaIndex) {
            e.addCapability(FUNNEL_HANDLER, new GenericCapabilityProvider<CorporeaRequesterFunnelable<TileCorporeaIndex>>(IncorporeticCygnusCapabilities.FUNNEL_CAP, new CorporeaRequesterFunnelable<TileCorporeaIndex>((TileCorporeaIndex)tile)));
        }
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> e) {
        Entity ent = (Entity)e.getObject();
        if (ent instanceof EntityItem) {
            e.addCapability(FUNNEL_HANDLER, new GenericCapabilityProvider<ItemEntityFunnelable>(IncorporeticCygnusCapabilities.FUNNEL_CAP, new ItemEntityFunnelable((EntityItem)ent)));
        } else if (ent instanceof EntityItemFrame) {
            e.addCapability(FUNNEL_HANDLER, new GenericCapabilityProvider<ItemFrameFunnelable>(IncorporeticCygnusCapabilities.FUNNEL_CAP, new ItemFrameFunnelable((EntityItemFrame)ent)));
        }
    }

    private static final class ItemFrameFunnelable
    extends AbstractItemStackFunnelable {
        private final EntityItemFrame frame;

        public ItemFrameFunnelable(EntityItemFrame frame) {
            this.frame = frame;
        }

        @Override
        protected ItemStack getStack() {
            return this.frame.func_82335_i();
        }

        @Override
        protected void setStack(ItemStack stack) {
            this.frame.func_82334_a(stack);
        }
    }

    private static final class ItemEntityFunnelable
    extends AbstractItemStackFunnelable {
        private final EntityItem ent;

        public ItemEntityFunnelable(EntityItem ent) {
            this.ent = ent;
        }

        @Override
        protected ItemStack getStack() {
            return this.ent.func_92059_d();
        }

        @Override
        protected void setStack(ItemStack stack) {
            this.ent.func_92058_a(stack);
        }
    }

    private static abstract class AbstractItemStackFunnelable
    implements ICygnusFunnelable {
        private AbstractItemStackFunnelable() {
        }

        protected abstract ItemStack getStack();

        protected abstract void setStack(ItemStack var1);

        private ItemCygnusTicket asTicket() {
            Item i = this.getStack().func_77973_b();
            if (i instanceof ItemCygnusTicket) {
                return (ItemCygnusTicket)i;
            }
            return null;
        }

        @Override
        public boolean canGiveCygnusItem() {
            ItemCygnusTicket ticket = this.asTicket();
            if (ticket != null) {
                return ticket.hasCygnusItem(this.getStack());
            }
            return !this.getStack().func_190926_b();
        }

        @Override
        public boolean canAcceptCygnusItem() {
            return this.asTicket() != null;
        }

        @Override
        @Nullable
        public Object giveItemToCygnus() {
            ItemStack stack = this.getStack();
            ItemCygnusTicket ticket = this.asTicket();
            if (ticket != null) {
                Object ret = ticket.getCygnusItem(stack);
                ticket.clearCygnusItem(stack);
                return ret;
            }
            ItemStack stackCopy = stack.func_77946_l();
            int count = stackCopy.func_190916_E();
            stackCopy.func_190920_e(1);
            return new CorporeaRequest((Object)stackCopy, true, count);
        }

        @Override
        public void acceptItemFromCygnus(Object item) {
            ItemCygnusTicket ticket = this.asTicket();
            if (ticket != null) {
                ItemStack ticketStack = this.getStack();
                ticket.setCygnusItem(ticketStack, item);
                this.setStack(ticketStack);
            }
        }
    }

    private static final class CorporeaRequesterFunnelable<T extends TileCorporeaBase>
    implements ICygnusFunnelable {
        private final T tile;

        public CorporeaRequesterFunnelable(T tile) {
            this.tile = tile;
        }

        @Override
        public boolean canAcceptCygnusItem() {
            return this.tile.getSpark() != null;
        }

        @Override
        public void acceptItemFromCygnus(Object item) {
            if (item instanceof CorporeaRequest) {
                CorporeaRequest request = (CorporeaRequest)item;
                ((ICorporeaRequestor)this.tile).doCorporeaRequest(request.matcher, request.count, this.tile.getSpark());
            }
        }
    }

    private static final class CorporeaCrystalCubeFunnelable
    implements ICygnusFunnelable {
        private final TileCorporeaCrystalCube crystalCube;

        public CorporeaCrystalCubeFunnelable(TileCorporeaCrystalCube crystalCube) {
            this.crystalCube = crystalCube;
        }

        @Override
        public boolean canGiveCygnusItem() {
            return !this.crystalCube.getRequestTarget().func_190926_b();
        }

        @Override
        public boolean canAcceptCygnusItem() {
            return true;
        }

        @Override
        public Object giveItemToCygnus() {
            ItemStack item = this.crystalCube.getRequestTarget();
            ItemStack item2 = item.func_77946_l();
            item2.func_190920_e(1);
            int count = this.crystalCube.getItemCount();
            return new CorporeaRequest((Object)item2, true, count);
        }

        @Override
        public void acceptItemFromCygnus(Object item) {
            if (item instanceof CorporeaRequest) {
                CorporeaRequest request = (CorporeaRequest)item;
                if (request.matcher instanceof ItemStack) {
                    this.crystalCube.setRequestTarget((ItemStack)request.matcher);
                }
            }
        }
    }

    private static final class CorporeaRetainerFunnelable
    implements ICygnusFunnelable {
        private final TileCorporeaRetainer retainer;

        public CorporeaRetainerFunnelable(TileCorporeaRetainer retainer) {
            this.retainer = retainer;
        }

        @Override
        public boolean canGiveCygnusItem() {
            return this.retainer.hasPendingRequest();
        }

        @Override
        public boolean canAcceptCygnusItem() {
            return true;
        }

        @Override
        @Nullable
        public Object giveItemToCygnus() {
            CorporeaRequest request = CorporeaHelper2.getCorporeaRequestInRetainer(this.retainer);
            if (request != null) {
                CorporeaHelper2.clearRetainer(this.retainer);
                return request;
            }
            return null;
        }

        @Override
        public void acceptItemFromCygnus(Object item) {
            if (item instanceof CorporeaRequest) {
                CorporeaHelper2.setCorporeaRequestInRetainer(this.retainer, (CorporeaRequest)item);
            }
        }
    }

    public static final class GenericCapabilityProvider<C>
    implements ICapabilityProvider {
        private final Capability<C> cap;
        private final C impl;

        public GenericCapabilityProvider(Capability<C> cap, C impl) {
            this.cap = cap;
            this.impl = impl;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == this.cap;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return capability == this.cap ? (T)this.impl : null;
        }
    }
}

