/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import quaternary.incorporeal.Incorporeal;
import quaternary.incorporeal.api.ISimpleRegistry;
import quaternary.incorporeal.api.cygnus.ICygnusStack;
import quaternary.incorporeal.cygnus.CygnusError;
import quaternary.incorporeal.cygnus.CygnusStack;
import quaternary.incorporeal.etc.helper.CorporeaHelper2;
import vazkii.botania.api.corporea.CorporeaRequest;

public final class IncorporeticCygnusActions {
    public static Consumer<ICygnusStack> NOTHING;

    private IncorporeticCygnusActions() {
    }

    public static void registerCygnusActions() {
        ISimpleRegistry<Consumer<ICygnusStack>> reg = Incorporeal.API.getCygnusStackActionRegistry();
        NOTHING = stack -> {};
        reg.register(new ResourceLocation("incorporeal", "nothing"), NOTHING);
        reg.register(new ResourceLocation("incorporeal", "duplicate"), stack -> stack.push(stack.peek().orElseGet(() -> new CygnusError("incorporeal.cygnus.error.stack_underflow"))));
        reg.register(new ResourceLocation("incorporeal", "number_add"), stack -> IncorporeticCygnusActions.pushIfMatching(BigInteger.class, BigInteger.class, stack, BigInteger::add));
        reg.register(new ResourceLocation("incorporeal", "number_subtract"), stack -> IncorporeticCygnusActions.pushIfMatching(BigInteger.class, BigInteger.class, stack, BigInteger::subtract));
        reg.register(new ResourceLocation("incorporeal", "number_multiply"), stack -> IncorporeticCygnusActions.pushIfMatching(BigInteger.class, BigInteger.class, stack, BigInteger::multiply));
        reg.register(new ResourceLocation("incorporeal", "number_divide"), stack -> IncorporeticCygnusActions.pushIfMatching(BigInteger.class, BigInteger.class, stack, (under, top) -> top.equals(BigInteger.ZERO) ? new CygnusError("incorporeal.cygnus.error.invalid_math", "incorporeal.cygnus.error.invalid_math.divide_by_0") : under.divide((BigInteger)top)));
        reg.register(new ResourceLocation("incorporeal", "number_remainder"), stack -> IncorporeticCygnusActions.pushIfMatching(BigInteger.class, BigInteger.class, stack, (under, top) -> top.equals(BigInteger.ZERO) ? new CygnusError("incorporeal.cygnus.error.invalid_math", "incorporeal.cygnus.error.invalid_math.divide_by_0") : under.remainder((BigInteger)top)));
        reg.register(new ResourceLocation("incorporeal", "request_get_count"), stack -> IncorporeticCygnusActions.pushIfMatching(CorporeaRequest.class, stack, req -> BigInteger.valueOf(req.count)));
        reg.register(new ResourceLocation("incorporeal", "request_set_count"), stack -> IncorporeticCygnusActions.pushIfMatching(CorporeaRequest.class, BigInteger.class, stack, (req, cnt) -> {
            CorporeaRequest copy = CorporeaHelper2.copyCorporeaRequest(req);
            copy.count = cnt.intValue();
            return copy;
        }));
        reg.register(new ResourceLocation("incorporeal", "request_set_item"), stack -> IncorporeticCygnusActions.pushIfMatching(CorporeaRequest.class, CorporeaRequest.class, stack, (donor, acceptor) -> new CorporeaRequest(donor.matcher, donor.checkNBT, acceptor.count)));
        reg.register(new ResourceLocation("incorporeal", "stack_get_depth"), stack -> IncorporeticCygnusActions.pushIfMatching(CygnusStack.class, stack, stackstack -> BigInteger.valueOf(stackstack.depth())));
    }

    private static <TOP> void pushIfMatching(Class<TOP> topClass, ICygnusStack stack, Function<TOP, Object> resultFactory) {
        stack.push(stack.peekMatching(topClass).flatMap(top -> {
            stack.popDestroy(1);
            return Optional.of(resultFactory.apply(top));
        }).orElseGet(() -> new CygnusError(stack.depth() < 1 ? "incorporeal.cygnus.error.stack_underflow" : "incorporeal.cygnus.error.mismatched_type")));
    }

    private static <TOP, UNDER> void pushIfMatching(Class<UNDER> underClass, Class<TOP> topClass, ICygnusStack stack, BiFunction<UNDER, TOP, Object> resultFactory) {
        stack.push(stack.peekMatching(topClass, 0).flatMap(top -> stack.peekMatching(underClass, 1).flatMap(under -> {
            stack.popDestroy(2);
            return Optional.of(resultFactory.apply(under, top));
        })).orElseGet(() -> new CygnusError(stack.depth() < 2 ? "incorporeal.cygnus.error.stack_underflow" : "incorporeal.cygnus.error.mismatched_type")));
    }
}

