/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.client.tesr;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelHumanoidHead;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import quaternary.incorporeal.etc.helper.EtcHelpers;
import quaternary.incorporeal.tile.soulcore.AbstractTileSoulCore;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class RenderTileSoulCore<T extends AbstractTileSoulCore>
extends TileEntitySpecialRenderer<T> {
    private final ResourceLocation cubesLocation;
    private final ModelHumanoidHead head = new ModelHumanoidHead();

    public RenderTileSoulCore(ResourceLocation cubesLocation) {
        this.cubesLocation = cubesLocation;
    }

    public void render(T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (this.field_147501_a == null) {
            this.func_147497_a(TileEntityRendererDispatcher.field_147556_a);
        }
        int hash = te == null ? 0 : MathHelper.func_188208_f((int)MathHelper.func_188208_f((int)te.func_174877_v().hashCode())) % 1500000;
        float ticks = (float)ClientTickHandler.ticksInGame + partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        float rotateY = ((float)hash + ticks) * 2.0f % 360.0f;
        GlStateManager.func_179114_b((float)rotateY, (float)0.0f, (float)1.0f, (float)0.0f);
        float verticalBob = EtcHelpers.sinDegrees(((float)hash + ticks) * 4.0f);
        GlStateManager.func_179137_b((double)0.0, (double)(0.1 * (double)verticalBob), (double)0.0);
        if (te == null) {
            GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
        } else {
            GlStateManager.func_179094_E();
            float wobble = ((float)hash + ticks) * 5.0f;
            float wobbleSin = EtcHelpers.sinDegrees(wobble);
            float wobbleCos = EtcHelpers.cosDegrees(wobble);
            float wobbleAmountDegrees = 10.0f;
            GlStateManager.func_179114_b((float)(wobbleCos * wobbleAmountDegrees), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(wobbleSin * wobbleAmountDegrees), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-wobbleCos * wobbleAmountDegrees), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-wobbleSin * wobbleAmountDegrees), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            ResourceLocation skullLocation = this.getSkullLocation(te);
            this.func_147499_a(skullLocation);
            this.head.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
        }
        this.func_147499_a(this.cubesLocation);
        GlStateManager.func_179114_b((float)((-ticks + (float)hash) / 5.0f % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)((ticks + (float)hash) / 50.0f)) * 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float wobble2 = ((float)hash + ticks) * 3.0f;
        float wobble2Sin = EtcHelpers.sinDegrees(wobble2);
        float wobble2Cos = EtcHelpers.cosDegrees(wobble2);
        float wobble2AmountDegrees = 10.0f;
        GlStateManager.func_179114_b((float)(-wobble2Cos * wobble2AmountDegrees), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-wobble2Sin * wobble2AmountDegrees), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(wobble2Cos * wobble2AmountDegrees), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(wobble2Sin * wobble2AmountDegrees), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179140_f();
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder b = t.func_178180_c();
        for (int i = 0; i < 8; ++i) {
            RenderTileSoulCore.drawBox(t, b, 0.1f, 0.1f, 0.1f, 0.35f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            if (i % 2 != 0) continue;
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private static void drawBox(Tessellator t, BufferBuilder b, float x1, float y1, float z1, float size) {
        float x2 = x1 + size;
        float y2 = y1 + size;
        float z2 = z1 + size;
        b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        b.func_181662_b((double)x1, (double)y1, (double)z1).func_187315_a(1.0, 1.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y1, (double)z1).func_187315_a(0.0, 1.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y1, (double)z2).func_187315_a(0.0, 0.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y1, (double)z2).func_187315_a(1.0, 0.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y2, (double)z1).func_187315_a(0.0, 0.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y2, (double)z2).func_187315_a(1.0, 0.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y2, (double)z2).func_187315_a(1.0, 1.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y2, (double)z1).func_187315_a(0.0, 1.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y1, (double)z1).func_187315_a(1.0, 1.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y2, (double)z1).func_187315_a(1.0, 0.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y2, (double)z1).func_187315_a(0.0, 0.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y1, (double)z1).func_187315_a(0.0, 1.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y1, (double)z2).func_187315_a(0.0, 0.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y1, (double)z2).func_187315_a(1.0, 0.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y2, (double)z2).func_187315_a(1.0, 1.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y2, (double)z2).func_187315_a(0.0, 1.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y1, (double)z1).func_187315_a(1.0, 1.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y1, (double)z2).func_187315_a(1.0, 0.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y2, (double)z2).func_187315_a(0.0, 0.0).func_181675_d();
        b.func_181662_b((double)x1, (double)y2, (double)z1).func_187315_a(0.0, 1.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y1, (double)z1).func_187315_a(0.0, 0.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y2, (double)z1).func_187315_a(1.0, 0.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y2, (double)z2).func_187315_a(1.0, 1.0).func_181675_d();
        b.func_181662_b((double)x2, (double)y1, (double)z2).func_187315_a(0.0, 1.0).func_181675_d();
        t.func_78381_a();
    }

    private ResourceLocation getSkullLocation(T te) {
        GameProfile skullProfile;
        ResourceLocation skullLocation = DefaultPlayerSkin.func_177335_a();
        if (te != null && (skullProfile = ((AbstractTileSoulCore)((Object)te)).getOwnerProfile()) != null) {
            Minecraft mc = Minecraft.func_71410_x();
            Map skin = mc.func_152342_ad().func_152788_a(skullProfile);
            skullLocation = skin.containsKey(MinecraftProfileTexture.Type.SKIN) ? mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)skin.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)skullProfile.getId());
        }
        return skullLocation;
    }
}

