/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.client.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import quaternary.incorporeal.block.decorative.BlockUnstableCube;
import quaternary.incorporeal.client.tesr.decorative.RenderTileUnstableCube;
import quaternary.incorporeal.tile.decorative.TileUnstableCube;

@Mod.EventBusSubscriber(modid="incorporeal", value={Side.CLIENT})
public final class BlockHighlightEventHandler {
    private static final AxisAlignedBB UNSTABLE_CUBE_HIGHLIGHT_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75).func_186662_g(0.002);

    private BlockHighlightEventHandler() {
    }

    @SubscribeEvent
    public static void renderBlockHighlight(DrawBlockHighlightEvent e) {
        RayTraceResult ray = e.getTarget();
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK && e.getPlayer().field_70170_p.func_180495_p(ray.func_178782_a()).func_177230_c() instanceof BlockUnstableCube) {
            BlockPos pos = ray.func_178782_a();
            TileEntity tile = e.getPlayer().field_70170_p.func_175625_s(pos);
            if (!(tile instanceof TileUnstableCube)) {
                return;
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            EntityPlayer player = e.getPlayer();
            double x = (double)pos.func_177958_n() - (player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks);
            double y = (double)pos.func_177956_o() - (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks);
            double z = (double)pos.func_177952_p() - (player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks);
            GlStateManager.func_179094_E();
            RenderTileUnstableCube.doTransformations((TileUnstableCube)tile, partialTicks, x, y, z);
            RenderGlobal.func_189697_a((AxisAlignedBB)UNSTABLE_CUBE_HIGHLIGHT_AABB, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            e.setCanceled(true);
        }
    }
}

