/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.block.naturaldevices;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;

public abstract class AbstractBlockNaturalDevice
extends Block
implements ILexiconable {
    public static final int TICK_DELAY = 20;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0625, 0.0, 1.0, 0.1875, 1.0);

    protected abstract boolean shouldPower(World var1, BlockPos var2, IBlockState var3);

    public AbstractBlockNaturalDevice() {
        super(Material.field_151594_q, MapColor.field_151650_B);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149713_g(0);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.canStay(world, pos);
    }

    protected boolean canStay(World world, BlockPos pos) {
        Material underMaterial = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        return underMaterial == Material.field_151578_c || underMaterial == Material.field_151577_b;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (world instanceof World && pos.func_177956_o() == neighbor.func_177956_o()) {
            IBlockState state = world.func_180495_p(pos);
            this.func_189540_a(state, (World)world, pos, state.func_177230_c(), neighbor);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.canStay(world, pos)) {
            this.updateState(world, pos, state);
        } else {
            world.func_175655_b(pos, true);
        }
    }

    protected void updateState(World world, BlockPos pos, IBlockState state) {
        boolean isPowered;
        boolean shouldPower = this.shouldPower(world, pos, state);
        if (shouldPower != (isPowered = ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) && !world.func_175691_a(pos, (Block)this)) {
            world.func_175654_a(pos, (Block)this, 20, isPowered ? -2 : -1);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean stillShouldPower = this.shouldPower(world, pos, state);
        boolean isPowered = (Boolean)state.func_177229_b((IProperty)LIT);
        if (isPowered && !stillShouldPower) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            this.notifyAround(world, pos, state);
        } else if (!isPowered) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            this.notifyAround(world, pos, state);
            if (stillShouldPower) {
                world.func_175654_a(pos, (Block)this, 20, -1);
            }
        }
    }

    private void notifyAround(World world, BlockPos pos, IBlockState state) {
        EnumFacing inputSide = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos notifyAroundPos = pos.func_177972_a(inputSide.func_176734_d());
        world.func_190524_a(notifyAroundPos, (Block)this, pos);
        world.func_175695_a(notifyAroundPos, (Block)this, inputSide);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state.func_185911_a(world, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false && state.func_177229_b((IProperty)FACING) == side ? 15 : 0;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side != null && (state.func_177229_b((IProperty)FACING) == side || state.func_177229_b((IProperty)FACING) == side.func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.shouldPower(world, pos, state)) {
            world.func_175684_a(pos, (Block)this, 1);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    public int func_176201_c(IBlockState state) {
        int rotationMask = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() & 3;
        int litMask = (Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0;
        return rotationMask | litMask;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.naturalDevices;
    }
}

