/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.block.cygnus;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import quaternary.incorporeal.api.cygnus.ICygnusSparkable;
import quaternary.incorporeal.api.cygnus.ICygnusStack;
import quaternary.incorporeal.block.IncorporeticStateProps;
import quaternary.incorporeal.block.cygnus.BlockCygnusBase;
import quaternary.incorporeal.block.properties.UnlistedSimpleRegistryProperty;
import quaternary.incorporeal.entity.cygnus.EntityCygnusMasterSpark;
import quaternary.incorporeal.etc.helper.CygnusHelpers;
import quaternary.incorporeal.item.cygnus.ItemCygnusWordCard;
import quaternary.incorporeal.tile.cygnus.TileCygnusWord;
import vazkii.botania.api.state.BotaniaStateProps;

public class BlockCygnusWord
extends BlockCygnusBase
implements ICygnusSparkable {
    public static final PropertyBool POWERED = BotaniaStateProps.POWERED;
    public static final UnlistedSimpleRegistryProperty<Consumer<ICygnusStack>> UNLISTED_ACTION = IncorporeticStateProps.UNLISTED_ACTION;

    public BlockCygnusWord() {
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean acceptsCygnusSpark(World world, IBlockState state, BlockPos pos) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean shouldPower;
        boolean isPowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (isPowered != (shouldPower = world.func_175640_z(pos))) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(shouldPower)));
        }
        if (!isPowered && shouldPower) {
            EntityCygnusMasterSpark master = CygnusHelpers.getMasterSparkForSparkAt(world, pos);
            TileEntity tile = world.func_175625_s(pos);
            if (master != null && tile instanceof TileCygnusWord) {
                ((TileCygnusWord)tile).accept(master.getCygnusStack());
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCygnusWord();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (held.func_77973_b() instanceof ItemCygnusWordCard && tile instanceof TileCygnusWord) {
            ItemCygnusWordCard card = (ItemCygnusWordCard)held.func_77973_b();
            TileCygnusWord word = (TileCygnusWord)tile;
            word.setAction((Consumer)card.readValue(held));
            return true;
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{POWERED}).add(new IUnlistedProperty[]{UNLISTED_ACTION}).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState stateExt = (IExtendedBlockState)state;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCygnusWord) {
            stateExt = stateExt.withProperty(UNLISTED_ACTION, ((TileCygnusWord)tile).getAction());
        }
        return stateExt;
    }
}

