/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;

public class BlockFrameTinkerer
extends Block
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);

    public BlockFrameTinkerer() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        if (!held.func_190926_b()) {
            if (!world.field_72995_K) {
                ItemStack deposit = held.func_77979_a(1);
                BlockFrameTinkerer.spawnItem(world, pos, deposit);
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean shouldPower = world.func_175687_A(pos) > 0;
        boolean isPowered = (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED);
        if (isPowered != shouldPower) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(shouldPower)));
            if (!world.field_72995_K && shouldPower) {
                EntityItem ent = null;
                ItemStack inWorldStack = null;
                List itemEnts = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos));
                if (itemEnts.isEmpty()) {
                    inWorldStack = ItemStack.field_190927_a;
                } else {
                    Collections.shuffle(itemEnts);
                    for (EntityItem e : itemEnts) {
                        if (e.func_92059_d().func_190926_b() || e.func_92059_d().func_190916_E() != 1) continue;
                        ent = e;
                        inWorldStack = e.func_92059_d();
                        break;
                    }
                    if (ent == null) {
                        return;
                    }
                }
                ArrayList nearbyFrames = new ArrayList(2);
                for (EntityItem horiz : EnumFacing.field_176754_o) {
                    nearbyFrames.addAll(world.func_72872_a(EntityItemFrame.class, new AxisAlignedBB(pos.func_177972_a((EnumFacing)horiz))));
                }
                if (nearbyFrames.isEmpty()) {
                    return;
                }
                EntityItemFrame frame = (EntityItemFrame)nearbyFrames.get(world.field_73012_v.nextInt(nearbyFrames.size()));
                ItemStack frameStack = frame.func_82335_i().func_77946_l();
                frame.func_82334_a(inWorldStack.func_77946_l());
                inWorldStack = frameStack;
                if (!inWorldStack.func_190926_b()) {
                    world.func_184148_a(null, frame.field_70165_t, frame.field_70163_u, frame.field_70161_v, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if (ent == null) {
                    BlockFrameTinkerer.spawnItem(world, pos, inWorldStack);
                } else {
                    ent.func_92058_a(inWorldStack);
                    ent.func_174867_a(30);
                }
            }
        }
    }

    private static void spawnItem(World world, BlockPos pos, ItemStack stack) {
        EntityItem ent = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1875, (double)pos.func_177952_p() + 0.5, stack);
        ent.field_70159_w = 0.0;
        ent.field_70181_x = 0.0;
        ent.field_70179_y = 0.0;
        ent.func_174867_a(30);
        world.func_72838_d((Entity)ent);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED) != false ? 1 : 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.frameTinkerer;
    }
}

