/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.corporea.TileCorporeaRetainer;

public class BlockCorporeaRetainerDecrementer
extends Block
implements ILexiconable {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockCorporeaRetainerDecrementer() {
        super(Material.field_151573_f);
        this.func_149711_c(5.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.updatePoweredState(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.updatePoweredState(world, pos, state);
    }

    private void updatePoweredState(World world, BlockPos pos, IBlockState state) {
        boolean isPowered;
        boolean shouldPower = world.func_175640_z(pos);
        if (shouldPower != (isPowered = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue())) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(shouldPower)));
            if (shouldPower) {
                for (EnumFacing horiz : EnumFacing.field_176754_o) {
                    TileCorporeaRetainer retainer;
                    TileEntity tile = world.func_175625_s(pos.func_177972_a(horiz));
                    if (!(tile instanceof TileCorporeaRetainer) || !(retainer = (TileCorporeaRetainer)tile).hasPendingRequest()) continue;
                    int retainerCount = (Integer)ReflectionHelper.getPrivateValue(TileCorporeaRetainer.class, (Object)retainer, (String[])new String[]{"requestCount"});
                    if (--retainerCount > 0) {
                        ReflectionHelper.setPrivateValue(TileCorporeaRetainer.class, (Object)retainer, (Object)retainerCount, (String[])new String[]{"requestCount"});
                    } else {
                        ReflectionHelper.setPrivateValue(TileCorporeaRetainer.class, (Object)retainer, (Object)false, (String[])new String[]{"pendingRequest"});
                    }
                    world.func_175666_e(pos.func_177972_a(horiz), ModBlocks.corporeaRetainer);
                }
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.corporeaRetainerDecrementer;
    }
}

