/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.apache.commons.lang3.tuple.Pair;
import quaternary.incorporeal.api.INaturalDeviceRegistry;

public final class IncorporealNaturalDeviceRegistry
implements INaturalDeviceRegistry {
    private final List<Pair<Function<Random, IBlockState>, Double>> devices = new ArrayList<Pair<Function<Random, IBlockState>, Double>>();
    private double totalWeight = 0.0;

    IncorporealNaturalDeviceRegistry() {
    }

    @Override
    public void register(Function<Random, IBlockState> deviceStateFactory, double weight) {
        this.devices.add((Pair<Function<Random, IBlockState>, Double>)Pair.of(deviceStateFactory, (Object)weight));
        this.totalWeight += weight;
    }

    @Override
    public IBlockState pullRandomDevice(Random rand) {
        if (this.devices.isEmpty()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        double choice = rand.nextDouble() * this.totalWeight;
        double runningSum = 0.0;
        for (Pair<Function<Random, IBlockState>, Double> entry : this.devices) {
            if (!((runningSum += ((Double)entry.getRight()).doubleValue()) >= choice)) continue;
            return (IBlockState)((Function)entry.getLeft()).apply(rand);
        }
        throw new RuntimeException("Error picking a natural device crop. This should be impossible? runningSum = " + runningSum + " choice = " + choice + " totalWeight = " + this.totalWeight);
    }
}

