/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import quaternary.incorporeal.IncorporeticConfig;
import quaternary.incorporeal.api.IIncorporealAPI;
import quaternary.incorporeal.api.impl.IncorporealAPI;
import quaternary.incorporeal.block.IncorporeticBlocks;
import quaternary.incorporeal.compat.infraredstone.InfraRedstoneCompat;
import quaternary.incorporeal.cygnus.CygnusDatatypeHelpers;
import quaternary.incorporeal.cygnus.CygnusRegistries;
import quaternary.incorporeal.cygnus.IncorporeticCygnusActions;
import quaternary.incorporeal.cygnus.IncorporeticCygnusConditions;
import quaternary.incorporeal.cygnus.IncorporeticCygnusDatatypes;
import quaternary.incorporeal.cygnus.cap.IncorporeticCygnusCapabilities;
import quaternary.incorporeal.entity.IncorporeticEntities;
import quaternary.incorporeal.etc.DispenserBehaviorRedstoneRoot;
import quaternary.incorporeal.etc.IncorporeticNaturalDevices;
import quaternary.incorporeal.etc.IncorporeticRuneRecipes;
import quaternary.incorporeal.etc.LooseRedstoneDustCygnusFunnelable;
import quaternary.incorporeal.etc.LooseRedstoneRepeaterCygnusFunnelable;
import quaternary.incorporeal.etc.helper.DespacitoHelper;
import quaternary.incorporeal.etc.proxy.ServerProxy;
import quaternary.incorporeal.flower.IncorporeticFlowers;
import quaternary.incorporeal.flower.IncorporeticPetalRecipes;
import quaternary.incorporeal.item.IncorporeticItems;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import quaternary.incorporeal.net.IncorporeticPacketHandler;
import quaternary.incorporeal.tile.IncorporeticTiles;
import vazkii.botania.common.item.ModItems;

@Mod(modid="incorporeal", name="Incorporeal", version="1.0.4", dependencies="required-after:botania;", guiFactory="quaternary.incorporeal.etc.configjunk.IncorporeticGuiFactory", updateJSON="https://raw.githubusercontent.com/quat1024/incorporeal/master/_static/forge_update.json", acceptedMinecraftVersions="[1.12.2]")
public final class Incorporeal {
    public static final String MODID = "incorporeal";
    public static final String NAME = "Incorporeal";
    public static final String VERSION = "1.0.4";
    public static final String DEPENDENCIES = "required-after:botania;";
    public static final Logger LOGGER = LogManager.getLogger((String)"Incorporeal");
    public static final IIncorporealAPI API = new IncorporealAPI();
    @SidedProxy(clientSide="quaternary.incorporeal.etc.proxy.ClientProxy", serverSide="quaternary.incorporeal.etc.proxy.ServerProxy")
    public static ServerProxy PROXY;
    public static final CreativeTabs TAB;

    @Mod.EventHandler
    public static void preinit(FMLPreInitializationEvent e) {
        IncorporeticConfig.preinit(e);
        IncorporeticCygnusCapabilities.preinit(e);
        IncorporeticCygnusActions.registerCygnusActions();
        IncorporeticCygnusConditions.registerCygnusConditions();
        IncorporeticCygnusDatatypes.registerCygnusDatatypes();
        PROXY.preinit();
        if (IncorporeticConfig.Compat.INFRAREDSTONE && Loader.isModLoaded((String)"infraredstone")) {
            InfraRedstoneCompat.preinit(e);
        }
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent e) {
        DespacitoHelper.init();
        CygnusRegistries.freezeRegistries();
        CygnusDatatypeHelpers.init();
        IncorporeticPacketHandler.init();
        IncorporeticPetalRecipes.init();
        IncorporeticRuneRecipes.init();
        IncorporeticNaturalDevices.init();
        IncorporeticLexicon.init();
        CygnusRegistries.LOOSE_FUNNELABLES.add(new LooseRedstoneDustCygnusFunnelable());
        CygnusRegistries.LOOSE_FUNNELABLES.add(new LooseRedstoneRepeaterCygnusFunnelable());
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.manaResource, (Object)new DispenserBehaviorRedstoneRoot());
    }

    @Mod.EventHandler
    public static void postinit(FMLPostInitializationEvent e) {
        if (IncorporeticConfig.Compat.INFRAREDSTONE && Loader.isModLoaded((String)"infraredstone")) {
            InfraRedstoneCompat.postinit(e);
        }
    }

    static {
        TAB = new CreativeTabs(MODID){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((Item)IncorporeticItems.TICKET_CONJURER);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(NonNullList<ItemStack> list) {
                super.func_78018_a(list);
                list.addAll(IncorporeticFlowers.getAllIncorporeticFlowerStacks());
            }
        };
    }

    @Mod.EventBusSubscriber(modid="incorporeal")
    public static final class CommonEvents {
        private CommonEvents() {
        }

        @SubscribeEvent
        public static void blocks(RegistryEvent.Register<Block> e) {
            IncorporeticBlocks.registerBlocks((IForgeRegistry<Block>)e.getRegistry());
            IncorporeticTiles.registerTileEntities();
        }

        @SubscribeEvent
        public static void items(RegistryEvent.Register<Item> e) {
            IncorporeticItems.registerItems((IForgeRegistry<Item>)e.getRegistry());
            IncorporeticFlowers.registerFlowers();
        }

        @SubscribeEvent
        public static void entityEntries(RegistryEvent.Register<EntityEntry> e) {
            IncorporeticEntities.registerEntityEntries((IForgeRegistry<EntityEntry>)e.getRegistry());
        }
    }
}

