/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockNetherBrick;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import paulevs.betternether.biomes.BiomeRegister;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.config.ConfigLoader;
import paulevs.betternether.noise.Dither;
import paulevs.betternether.noise.WorleyNoiseIDDistorted3D;
import paulevs.betternether.structures.IStructureWorld;
import paulevs.betternether.structures.StructureAltar;
import paulevs.betternether.structures.StructureBlackApple;
import paulevs.betternether.structures.StructureBuilding;
import paulevs.betternether.structures.StructureEggPlant;
import paulevs.betternether.structures.StructureEye;
import paulevs.betternether.structures.StructureGrayMold;
import paulevs.betternether.structures.StructureInkBush;
import paulevs.betternether.structures.StructureLucis;
import paulevs.betternether.structures.StructureMagmaFlower;
import paulevs.betternether.structures.StructureMedBrownMushroom;
import paulevs.betternether.structures.StructureMedRedMushroom;
import paulevs.betternether.structures.StructureOrangeMushroom;
import paulevs.betternether.structures.StructureRedMold;
import paulevs.betternether.structures.StructureSmoker;
import paulevs.betternether.structures.StructureStalagnate;
import paulevs.betternether.structures.StructureWartCap;
import paulevs.betternether.structures.StructureWartTree;
import paulevs.betternether.structures.city.CityGenerator;

public class BNWorldGenerator {
    public static StructureEye eyeGen = new StructureEye();
    public static StructureStalagnate stalagnateGen = new StructureStalagnate();
    public static StructureLucis lucisGen = new StructureLucis();
    public static StructureSmoker smokerGen = new StructureSmoker();
    public static StructureWartTree wartTreeGen = new StructureWartTree();
    public static StructureEggPlant eggPlantGen = new StructureEggPlant();
    public static StructureInkBush inkBushGen = new StructureInkBush();
    public static StructureBlackApple blackAppleGen = new StructureBlackApple();
    public static StructureMagmaFlower magmaFlowerGen = new StructureMagmaFlower();
    public static StructureMedRedMushroom redMushroomGen = new StructureMedRedMushroom();
    public static StructureMedBrownMushroom brownMushroomGen = new StructureMedBrownMushroom();
    public static StructureOrangeMushroom orangeMushroomGen = new StructureOrangeMushroom();
    public static StructureRedMold redMoldGen = new StructureRedMold();
    public static StructureGrayMold grayMoldGen = new StructureGrayMold();
    public static StructureWartCap wartCapGen = new StructureWartCap();
    public static CityGenerator cityGenerator;
    public static IStructureWorld[] globalStructuresLand;
    public static IStructureWorld[] globalStructuresLava;
    public static IStructureWorld[] globalStructuresCave;
    public static boolean hasCleaningPass;
    public static boolean hasEyeGen;
    public static boolean hasStalagnateGen;
    public static boolean hasLucisGen;
    public static boolean hasSmokerGen;
    public static boolean hasWartTreeGen;
    public static boolean hasEggPlantGen;
    public static boolean hasInkBushGen;
    public static boolean hasBlackAppleGen;
    public static boolean hasMagmaFlowerGen;
    public static boolean hasRedMushroomGen;
    public static boolean hasBrownMushroomGen;
    public static boolean hasOrangeMushroomGen;
    public static boolean hasRedMoldGen;
    public static boolean hasGrayMoldGen;
    private static WorleyNoiseIDDistorted3D noise3d;
    private static WorleyNoiseIDDistorted3D subbiomesNoise;
    private static Dither dither;
    private static double biomeSizeXZ;
    private static double biomeSizeY;
    private static double subBiomeSize;
    private static float plantDensity;
    public static boolean enablePlayerDamage;
    public static boolean enableMobDamage;
    private static Random coordinateRandom;

    public static void init(long seed) {
        noise3d = new WorleyNoiseIDDistorted3D(seed, BiomeRegister.biomeCount);
        subbiomesNoise = new WorleyNoiseIDDistorted3D(seed ^ 0xFFFFFFFFFFFFFFFFL, 256);
        dither = new Dither(seed);
        coordinateRandom = new Random();
    }

    public static void generate(World world, Chunk chunk, Random random) {
        if (!world.field_72995_K) {
            int y;
            BlockPos start;
            int sx = chunk.field_76635_g << 4;
            int sz = chunk.field_76647_h << 4;
            coordinateRandom.setSeed((long)chunk.field_76635_g * 341873128712L + (long)chunk.field_76647_h * 132897987541L);
            if ((chunk.field_76635_g & 0x1F) == 0 && (chunk.field_76647_h & 0x1F) == 0 && coordinateRandom.nextBoolean() && world.func_180495_p((start = new BlockPos(8, 32, 8)).func_177977_b()).func_185904_a() == Material.field_151587_i) {
                boolean generate = true;
                for (y = 0; y < 20; ++y) {
                    if (chunk.func_177435_g(start.func_177981_b(y)).func_177230_c() == Blocks.field_150350_a) continue;
                    generate = false;
                    break;
                }
                if (generate) {
                    cityGenerator.generate(world, start.func_177982_a(sx, 16 + coordinateRandom.nextInt(8), sz), coordinateRandom);
                }
            }
            if (coordinateRandom.nextInt(16) == 0) {
                start = new BlockPos(coordinateRandom.nextInt(16), 32 + coordinateRandom.nextInt(88), coordinateRandom.nextInt(16));
                while (chunk.func_177435_g(start).func_177230_c() != Blocks.field_150350_a && start.func_177956_o() > 32) {
                    start = start.func_177977_b();
                }
                if ((start = BNWorldGenerator.downRay(chunk, start)) != null) {
                    boolean terrain = true;
                    for (y = 1; y < 8; ++y) {
                        if (chunk.func_177435_g(start.func_177981_b(y)).func_177230_c() == Blocks.field_150350_a) continue;
                        terrain = false;
                        break;
                    }
                    if (terrain) {
                        if ((globalStructuresLava.length <= 0 || chunk.func_177435_g(start).func_185904_a() != Material.field_151587_i) && globalStructuresLand.length > 0) {
                            globalStructuresLand[coordinateRandom.nextInt(globalStructuresLand.length)].generateSurface(chunk.func_177412_p(), start.func_177982_a(sx, 1, sz), coordinateRandom);
                        }
                    } else if (globalStructuresCave.length > 0) {
                        globalStructuresCave[coordinateRandom.nextInt(globalStructuresCave.length)].generateSubterrain(chunk.func_177412_p(), start.func_177982_a(sx, 0, sz), coordinateRandom);
                    }
                }
            }
            for (int x = 0; x < 16; ++x) {
                int wx = sx | x;
                for (int z = 0; z < 16; ++z) {
                    int wz = sz | z;
                    for (int y2 = 5; y2 < 126; ++y2) {
                        if (chunk.func_186032_a(x, y2, z).func_185913_b()) {
                            NetherBiome biome;
                            int id = BNWorldGenerator.getBiome(wx, y2, wz);
                            biome = BNWorldGenerator.isEdge(id, wx, y2, wz, (biome = BiomeRegister.getBiomeID(id)).getEdgeSize()) ? biome.getEdge() : biome.getSubBiome(wx, y2, wz);
                            if (chunk.func_186032_a(x, y2 + 1, z).func_177230_c() == Blocks.field_150350_a) {
                                biome.genSurfColumn(chunk, new BlockPos(x, y2, z), random);
                                if (random.nextFloat() <= plantDensity) {
                                    biome.genFloorObjects(chunk, new BlockPos(x, y2, z), random);
                                }
                            } else if (chunk.func_186032_a(x, y2 - 1, z).func_177230_c() == Blocks.field_150350_a) {
                                if (random.nextFloat() <= plantDensity) {
                                    biome.genCeilObjects(chunk, new BlockPos(x, y2, z), random);
                                }
                            } else if (x > 1 && z > 1 && x < 14 && z < 14) {
                                boolean bWest;
                                BlockPos origin = new BlockPos(x, y2, z);
                                boolean bNorth = chunk.func_186032_a(x + 1, y2, z).func_177230_c() == Blocks.field_150350_a;
                                boolean bSouth = chunk.func_186032_a(x - 1, y2, z).func_177230_c() == Blocks.field_150350_a;
                                boolean bEast = chunk.func_186032_a(x, y2, z + 1).func_177230_c() == Blocks.field_150350_a;
                                boolean bl = bWest = chunk.func_186032_a(x, y2, z - 1).func_177230_c() == Blocks.field_150350_a;
                                if (bNorth || bSouth || bEast || bWest) {
                                    boolean bUp;
                                    BlockPos pos = null;
                                    pos = bNorth ? origin.func_177978_c() : (bSouth ? origin.func_177968_d() : (bEast ? origin.func_177974_f() : origin.func_177976_e()));
                                    boolean bDown = chunk.func_177435_g(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a;
                                    boolean bl2 = bUp = chunk.func_177435_g(pos.func_177977_b()).func_177230_c() == Blocks.field_150350_a;
                                    if (bDown && bUp) {
                                        if (random.nextFloat() <= plantDensity) {
                                            biome.genWallObjects(chunk, origin, pos, random);
                                        }
                                        if (y2 < 50 && chunk.func_186032_a(x, y2, z).func_177230_c() instanceof BlockNetherBrick && random.nextInt(16) == 0) {
                                            wartCapGen.generate(chunk, origin, random);
                                        }
                                    }
                                }
                            }
                        }
                        if (BlocksRegister.BLOCK_CINCINNASITE_ORE == Blocks.field_150350_a || random.nextInt(1024) != 0) continue;
                        BNWorldGenerator.spawnOre(BlocksRegister.BLOCK_CINCINNASITE_ORE.func_176223_P(), chunk, x, y2, z, random);
                    }
                }
            }
        }
    }

    private static boolean isEdge(int centerID, int x, int y, int z, int distance) {
        return distance > 0 && (centerID != BNWorldGenerator.getBiome(x + distance, y, z) || centerID != BNWorldGenerator.getBiome(x - distance, y, z) || centerID != BNWorldGenerator.getBiome(x, y + distance, z) || centerID != BNWorldGenerator.getBiome(x, y - distance, z) || centerID != BNWorldGenerator.getBiome(x, y, z + distance) || centerID != BNWorldGenerator.getBiome(x, y, z - distance));
    }

    private static int getBiome(int x, int y, int z) {
        double px = (double)dither.ditherX(x, y, z) * biomeSizeXZ;
        double py = (double)dither.ditherY(x, y, z) * biomeSizeY;
        double pz = (double)dither.ditherZ(x, y, z) * biomeSizeXZ;
        return noise3d.GetValue(px, py, pz);
    }

    public static void smoothChunk(Chunk chunk) {
        if (hasCleaningPass) {
            ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
            for (int y = 32; y < 110; ++y) {
                int i;
                for (int x = 1; x < 15; ++x) {
                    for (int z = 1; z < 15; ++z) {
                        if (!BNWorldGenerator.canReplace(chunk, x, y, z)) continue;
                        if (BNWorldGenerator.isAir(chunk, x - 1, y, z) && BNWorldGenerator.isAir(chunk, x + 1, y, z)) {
                            pos.add(new BlockPos(x, y, z));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(chunk, x, y - 1, z) && BNWorldGenerator.isAir(chunk, x, y + 1, z)) {
                            pos.add(new BlockPos(x, y, z));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(chunk, x, y, z - 1) && BNWorldGenerator.isAir(chunk, x, y, z + 1)) {
                            pos.add(new BlockPos(x, y, z));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(chunk, x - 1, y - 1, z - 1) && BNWorldGenerator.isAir(chunk, x + 1, y + 1, z + 1)) {
                            pos.add(new BlockPos(x, y, z));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(chunk, x + 1, y - 1, z - 1) && BNWorldGenerator.isAir(chunk, x - 1, y + 1, z + 1)) {
                            pos.add(new BlockPos(x, y, z));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(chunk, x + 1, y - 1, z + 1) && BNWorldGenerator.isAir(chunk, x - 1, y + 1, z - 1)) {
                            pos.add(new BlockPos(x, y, z));
                            continue;
                        }
                        if (!BNWorldGenerator.isAir(chunk, x - 1, y - 1, z + 1) || !BNWorldGenerator.isAir(chunk, x + 1, y + 1, z - 1)) continue;
                        pos.add(new BlockPos(x, y, z));
                    }
                }
                for (i = 0; i < 16; ++i) {
                    if (BNWorldGenerator.canReplace(chunk, i, y, 0) && BNWorldGenerator.isAir(chunk, i, y - 1, 0) && BNWorldGenerator.isAir(chunk, i, y + 1, 0)) {
                        pos.add(new BlockPos(i, y, 0));
                    }
                    if (!BNWorldGenerator.canReplace(chunk, i, y, 15) || !BNWorldGenerator.isAir(chunk, i, y - 1, 15) || !BNWorldGenerator.isAir(chunk, i, y + 1, 15)) continue;
                    pos.add(new BlockPos(i, y, 15));
                }
                for (i = 1; i < 15; ++i) {
                    if (BNWorldGenerator.canReplace(chunk, 0, y, i) && BNWorldGenerator.isAir(chunk, 0, y - 1, i) && BNWorldGenerator.isAir(chunk, 0, y + 1, i)) {
                        pos.add(new BlockPos(0, y, i));
                    }
                    if (!BNWorldGenerator.canReplace(chunk, 15, y, i) || !BNWorldGenerator.isAir(chunk, 15, y - 1, i) || !BNWorldGenerator.isAir(chunk, 15, y + 1, i)) continue;
                    pos.add(new BlockPos(15, y, i));
                }
            }
            for (BlockPos p : pos) {
                chunk.func_177436_a(p, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    private static boolean isAir(Chunk chunk, int x, int y, int z) {
        return chunk.func_186032_a(x, y, z).func_177230_c() == Blocks.field_150350_a;
    }

    private static boolean canReplace(Chunk chunk, int x, int y, int z) {
        return !BNWorldGenerator.isAir(chunk, x, y, z) && (chunk.func_186032_a(x, y, z).func_177230_c() instanceof BlockNetherrack || chunk.func_186032_a(x, y, z).func_177230_c() instanceof BlockSoulSand || chunk.func_186032_a(x, y, z).func_177230_c() instanceof BlockGravel);
    }

    private static void spawnOre(IBlockState state, Chunk chunk, int x, int y, int z, Random random) {
        for (int i = 0; i < 6 + random.nextInt(11); ++i) {
            int pz;
            int py;
            int px = x + random.nextInt(3);
            if (chunk.func_186032_a(px, py = y + random.nextInt(3), pz = z + random.nextInt(3)).func_177230_c() != Blocks.field_150424_aL) continue;
            chunk.func_177436_a(new BlockPos(px, py, pz), state);
        }
    }

    public static void updateGenSettings() {
        biomeSizeXZ = 1.0 / (double)ConfigLoader.getBiomeSizeXZ();
        biomeSizeY = 1.0 / (double)ConfigLoader.getBiomeSizeY();
        subBiomeSize = biomeSizeXZ * 3.0;
        hasCleaningPass = ConfigLoader.hasCleaningPass();
        hasEyeGen = BlocksRegister.BLOCK_EYE_VINE != Blocks.field_150350_a && BlocksRegister.BLOCK_EYEBALL != Blocks.field_150350_a && BlocksRegister.BLOCK_EYEBALL_SMALL != Blocks.field_150350_a;
        hasStalagnateGen = BlocksRegister.BLOCK_STALAGNATE_BOTTOM != Blocks.field_150350_a && BlocksRegister.BLOCK_STALAGNATE_MIDDLE != Blocks.field_150350_a && BlocksRegister.BLOCK_STALAGNATE_TOP != Blocks.field_150350_a;
        hasLucisGen = BlocksRegister.BLOCK_LUCIS_MUSHROOM != Blocks.field_150350_a;
        hasSmokerGen = BlocksRegister.BLOCK_SMOKER != Blocks.field_150350_a;
        hasWartTreeGen = BlocksRegister.BLOCK_WART_SEED != Blocks.field_150350_a;
        hasEggPlantGen = BlocksRegister.BLOCK_EGG_PLANT != Blocks.field_150350_a;
        hasInkBushGen = BlocksRegister.BLOCK_INK_BUSH != Blocks.field_150350_a;
        hasBlackAppleGen = BlocksRegister.BLOCK_BLACK_APPLE != Blocks.field_150350_a;
        hasMagmaFlowerGen = BlocksRegister.BLOCK_MAGMA_FLOWER != Blocks.field_150350_a;
        hasRedMushroomGen = BlocksRegister.BLOCK_RED_LARGE_MUSHROOM != Blocks.field_150350_a;
        hasBrownMushroomGen = BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM != Blocks.field_150350_a;
        hasOrangeMushroomGen = BlocksRegister.BLOCK_ORANGE_MUSHROOM != Blocks.field_150350_a;
        hasRedMoldGen = BlocksRegister.BLOCK_RED_MOLD != Blocks.field_150350_a;
        hasGrayMoldGen = BlocksRegister.BLOCK_GRAY_MOLD != Blocks.field_150350_a;
        globalStructuresLand = new IStructureWorld[]{new StructureAltar(), new StructureBuilding("altar_01", -1), new StructureBuilding("altar_02", -4), new StructureBuilding("altar_03", -3), new StructureBuilding("altar_04", -3), new StructureBuilding("altar_05", -2), new StructureBuilding("altar_06", -2), new StructureBuilding("portal_01", -4), new StructureBuilding("portal_02", -3), new StructureBuilding("garden_01", -3), new StructureBuilding("garden_02", -2), new StructureBuilding("pillar_01", -1), new StructureBuilding("respawn_point_01", -3), new StructureBuilding("respawn_point_02", -2)};
        globalStructuresLava = new IStructureWorld[0];
        globalStructuresCave = new IStructureWorld[]{new StructureBuilding("room_01", -5)};
        cityGenerator = new CityGenerator();
    }

    private static BlockPos downRay(Chunk chunk, BlockPos start) {
        boolean dist = false;
        for (int j = start.func_177956_o(); j > 31; --j) {
            Block b = chunk.func_186032_a(start.func_177958_n(), j, start.func_177952_p()).func_177230_c();
            if (b == Blocks.field_150350_a || !(b instanceof BlockNetherrack) && !(b instanceof BlockSoulSand) && chunk.func_186032_a(start.func_177958_n(), j, start.func_177952_p()).func_185904_a() != Material.field_151587_i) continue;
            return new BlockPos(start.func_177958_n(), j, start.func_177952_p());
        }
        return null;
    }

    public static void setDensity(float density) {
        plantDensity = density;
    }

    public static int getSubBiome(int x, int y, int z, int count) {
        double px = (double)dither.ditherX(x, y, z) * subBiomeSize;
        double py = (double)dither.ditherY(x, y, z) * subBiomeSize;
        double pz = (double)dither.ditherZ(x, y, z) * subBiomeSize;
        return subbiomesNoise.GetValue(px, py, pz) % count;
    }

    public static NetherBiome getBiome(BlockPos pos) {
        int id = BNWorldGenerator.getBiome(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        NetherBiome biome = BiomeRegister.getBiomeID(id);
        biome = BNWorldGenerator.isEdge(id, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), biome.getEdgeSize()) ? biome.getEdge() : biome.getSubBiome(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return biome;
    }

    static {
        hasCleaningPass = true;
        hasEyeGen = true;
        hasStalagnateGen = true;
        hasLucisGen = true;
        hasSmokerGen = true;
        hasWartTreeGen = true;
        hasEggPlantGen = true;
        hasInkBushGen = true;
        hasBlackAppleGen = true;
        hasMagmaFlowerGen = true;
        hasRedMushroomGen = true;
        hasBrownMushroomGen = true;
        hasOrangeMushroomGen = true;
        hasRedMoldGen = true;
        hasGrayMoldGen = true;
        plantDensity = 1.0f;
    }
}

