/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.city;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import paulevs.betternether.structures.StructureNBT;
import paulevs.betternether.structures.city.BoundingBox;

public class StructureCityBuilding
extends StructureNBT {
    private BoundingBox bb;
    private BlockPos[] ends;
    private EnumFacing[] dirs;
    private BlockPos rotationOffset;
    private Rotation rotation;
    private int offsetY;

    public StructureCityBuilding(String structure) {
        super(structure);
        this.offsetY = 0;
        this.init();
    }

    public StructureCityBuilding(String structure, int offsetY) {
        super(structure);
        this.offsetY = offsetY;
        this.init();
    }

    protected StructureCityBuilding(ResourceLocation location, Template template) {
        super(location, template);
        this.init();
    }

    private void init() {
        BlockPos size = this.template.func_186259_a();
        this.bb = new BoundingBox(size);
        Map map = this.template.func_186258_a(BlockPos.field_177992_a, DEFAULT_SETTINGS);
        this.ends = new BlockPos[map.size()];
        this.dirs = new EnumFacing[map.size()];
        int i = 0;
        BlockPos center = new BlockPos(size.func_177958_n() >> 1, size.func_177956_o(), size.func_177952_p() >> 1);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            this.ends[i] = pos = (BlockPos)iterator.next();
            this.dirs[i++] = this.getDir(pos.func_177982_a(-center.func_177958_n(), 0, -center.func_177952_p()));
        }
        this.rotationOffset = new BlockPos(0, 0, 0);
        this.rotation = Rotation.NONE;
    }

    private EnumFacing getDir(BlockPos pos) {
        int az;
        int ax = Math.abs(pos.func_177958_n());
        int mx = Math.max(ax, az = Math.abs(pos.func_177952_p()));
        if (mx == ax) {
            if (pos.func_177958_n() > 0) {
                return EnumFacing.EAST;
            }
            return EnumFacing.WEST;
        }
        if (pos.func_177952_p() > 0) {
            return EnumFacing.SOUTH;
        }
        return EnumFacing.NORTH;
    }

    public BoundingBox getBoungingBox() {
        return this.bb;
    }

    public void place(World world, BlockPos pos) {
        BlockPos p = pos.func_177971_a((Vec3i)this.rotationOffset);
        this.template.func_186253_b(world, p, DEFAULT_SETTINGS.func_186220_a(this.rotation));
        for (BlockPos rep : this.ends) {
            world.func_175656_a(rep.func_177971_a((Vec3i)pos), Blocks.field_150350_a.func_176223_P());
        }
        for (int x = 0; x < this.bb.x2; ++x) {
            for (int z = 0; z < this.bb.z2; ++z) {
                int d;
                p = pos.func_177982_a(x, 0, z);
                IBlockState state = world.func_180495_p(p);
                if (!state.func_185913_b()) continue;
                for (d = 1; d < pos.func_177956_o() - 5 && !world.func_180495_p(p.func_177979_c(d)).func_185913_b(); ++d) {
                }
                for (int y = 1; y < d; ++y) {
                    world.func_175656_a(p.func_177979_c(y), state);
                }
            }
        }
    }

    public BlockPos[] getEnds() {
        return this.ends;
    }

    public int getEndsCount() {
        return this.ends.length;
    }

    public BlockPos getOffsettedPos(int index) {
        return this.ends[index].func_177972_a(this.dirs[index]);
    }

    public BlockPos getPos(int index) {
        return this.ends[index];
    }

    public StructureCityBuilding getRotated(Rotation rotation) {
        StructureCityBuilding building = this.clone();
        building.rotation = rotation;
        building.rotationOffset = building.template.func_186259_a().func_190942_a(rotation);
        int x = building.rotationOffset.func_177958_n();
        int z = building.rotationOffset.func_177952_p();
        x = x < 0 ? -x - 1 : 0;
        z = z < 0 ? -z - 1 : 0;
        building.rotationOffset = new BlockPos(x, 0, z);
        for (int i = 0; i < building.dirs.length; ++i) {
            building.dirs[i] = this.rotated(building.dirs[i], rotation);
            building.ends[i] = building.ends[i].func_190942_a(rotation).func_177971_a((Vec3i)building.rotationOffset);
        }
        building.bb.rotate(rotation);
        building.offsetY = this.offsetY;
        return building;
    }

    public StructureCityBuilding getRandomRotated(Random random) {
        return this.getRotated(Rotation.values()[random.nextInt(Rotation.values().length)]);
    }

    public StructureCityBuilding clone() {
        return new StructureCityBuilding(this.location, this.template);
    }

    private EnumFacing rotated(EnumFacing dir, Rotation rotation) {
        EnumFacing f;
        switch (rotation) {
            case CLOCKWISE_90: {
                f = dir.func_176746_e();
                break;
            }
            case CLOCKWISE_180: {
                f = dir.func_176734_d();
                break;
            }
            case COUNTERCLOCKWISE_90: {
                f = dir.func_176735_f();
                break;
            }
            default: {
                f = dir;
            }
        }
        return f;
    }

    public int getYOffset() {
        return this.offsetY;
    }
}

