/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.city;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import paulevs.betternether.structures.city.BoundingBox;
import paulevs.betternether.structures.city.StructureCityBuilding;

public class CityGenerator {
    private List<StructureCityBuilding> buildings = new ArrayList<StructureCityBuilding>();
    private List<StructureCityBuilding> roadEnds = new ArrayList<StructureCityBuilding>();
    private List<BoundingBox> bounds = new ArrayList<BoundingBox>();
    private List<BlockPos> ends = new ArrayList<BlockPos>();
    private List<BlockPos> add = new ArrayList<BlockPos>();
    private List<BlockPos> rem = new ArrayList<BlockPos>();

    public CityGenerator() {
        this.addBuildingToList("city_center", -10);
        this.addBuildingToList("city_library_01");
        this.addBuildingToList("city_building_01");
        this.addBuildingToList("city_building_02");
        this.addBuildingToList("city_building_03");
        this.addBuildingToList("city_building_04");
        this.addBuildingToList("city_building_05");
        this.addBuildingToList("city_building_06");
        this.addBuildingToList("city_enchanter_01");
        this.addRoadEndToList("road_end_01");
        this.addRoadEndToList("road_end_02", -2);
    }

    private void addBuildingToList(String name) {
        StructureCityBuilding building = new StructureCityBuilding("city/" + name);
        this.buildings.add(building);
        this.buildings.add(building.getRotated(Rotation.CLOCKWISE_90));
        this.buildings.add(building.getRotated(Rotation.CLOCKWISE_180));
        this.buildings.add(building.getRotated(Rotation.COUNTERCLOCKWISE_90));
    }

    private void addBuildingToList(String name, int offsetY) {
        StructureCityBuilding building = new StructureCityBuilding("city/" + name, offsetY);
        this.buildings.add(building);
        this.buildings.add(building.getRotated(Rotation.CLOCKWISE_90));
        this.buildings.add(building.getRotated(Rotation.CLOCKWISE_180));
        this.buildings.add(building.getRotated(Rotation.COUNTERCLOCKWISE_90));
    }

    private void addRoadEndToList(String name) {
        StructureCityBuilding building = new StructureCityBuilding("city/" + name);
        this.roadEnds.add(building);
        this.roadEnds.add(building.getRotated(Rotation.CLOCKWISE_90));
        this.roadEnds.add(building.getRotated(Rotation.CLOCKWISE_180));
        this.roadEnds.add(building.getRotated(Rotation.COUNTERCLOCKWISE_90));
    }

    private void addRoadEndToList(String name, int offsetY) {
        StructureCityBuilding building = new StructureCityBuilding("city/" + name, offsetY);
        this.roadEnds.add(building);
        this.roadEnds.add(building.getRotated(Rotation.CLOCKWISE_90));
        this.roadEnds.add(building.getRotated(Rotation.CLOCKWISE_180));
        this.roadEnds.add(building.getRotated(Rotation.COUNTERCLOCKWISE_90));
    }

    private void placeCenterBuilding(World world, BlockPos pos, StructureCityBuilding building) {
        BoundingBox bb = building.getBoungingBox().offset(pos);
        this.bounds.add(bb);
        building.place(world, pos.func_177982_a(0, building.getYOffset(), 0));
        for (int i = 0; i < building.getEndsCount(); ++i) {
            this.ends.add(pos.func_177971_a((Vec3i)building.getOffsettedPos(i).func_177982_a(0, building.getYOffset(), 0)));
        }
    }

    private void attachBuildings(World world, Random random) {
        block0: for (BlockPos pos : this.ends) {
            for (int n = 0; n < 8; ++n) {
                StructureCityBuilding building = this.buildings.get(4 + random.nextInt(this.buildings.size() - 4));
                int index = random.nextInt(building.getEndsCount());
                BlockPos offset = building.getPos(index);
                BoundingBox bb = building.getBoungingBox().offset(pos).offsetNegative(offset);
                if (!this.noCollisions(bb)) continue;
                BlockPos npos = new BlockPos(bb.x1, pos.func_177956_o() - offset.func_177956_o() + building.getYOffset(), bb.z1);
                this.bounds.add(bb);
                this.rem.add(pos);
                for (int i = 0; i < building.getEndsCount(); ++i) {
                    if (i == index) continue;
                    this.add.add(npos.func_177971_a((Vec3i)building.getOffsettedPos(i)));
                }
                building.place(world, npos);
                continue block0;
            }
        }
        this.ends.removeAll(this.rem);
        this.ends.addAll(this.add);
        this.rem.clear();
        this.add.clear();
    }

    private void closeRoads(World world) {
        block0: for (BlockPos pos : this.ends) {
            for (int n = 0; n < this.roadEnds.size(); ++n) {
                StructureCityBuilding building = this.roadEnds.get(n);
                BlockPos offset = building.getPos(0);
                BoundingBox bb = building.getBoungingBox().offset(pos).offsetNegative(offset);
                if (!this.noCollisions(bb)) continue;
                BlockPos npos = new BlockPos(bb.x1, pos.func_177956_o() - offset.func_177956_o() + building.getYOffset(), bb.z1);
                this.bounds.add(bb);
                building.place(world, npos);
                continue block0;
            }
        }
        this.ends.clear();
        this.bounds.clear();
        this.rem.clear();
        this.add.clear();
    }

    public void generate(World world, BlockPos pos, Random random) {
        this.placeCenterBuilding(world, pos, this.buildings.get(random.nextInt(4)));
        for (int i = 0; i < 2 + random.nextInt(4); ++i) {
            this.attachBuildings(world, random);
        }
        this.closeRoads(world);
    }

    private boolean noCollisions(BoundingBox bb) {
        for (BoundingBox b : this.bounds) {
            if (!bb.isColliding(b)) continue;
            return false;
        }
        return true;
    }
}

