/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.city;

import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class BoundingBox {
    int x1;
    int x2;
    int z1;
    int z2;

    public BoundingBox(int x1, int z1, int x2, int z2) {
        this.x1 = x1;
        this.x2 = x2;
        this.z1 = z1;
        this.z2 = z2;
    }

    public BoundingBox(BlockPos size, int offsetX, int offsetZ) {
        this.x1 = offsetX;
        this.x2 = this.x1 + size.func_177958_n();
        this.z1 = offsetZ;
        this.z2 = this.z1 + size.func_177952_p();
    }

    public BoundingBox(BlockPos size) {
        this.x1 = 0;
        this.x2 = size.func_177958_n();
        this.z1 = 0;
        this.z2 = size.func_177952_p();
    }

    public boolean isColliding(BoundingBox bb) {
        boolean colX = bb.x1 < this.x2 && this.x1 < bb.x2;
        boolean colZ = bb.z1 < this.z2 && this.z1 < bb.z2;
        return colX && colZ;
    }

    public BoundingBox offset(BlockPos offset) {
        return new BoundingBox(this.x1 + offset.func_177958_n(), this.z1 + offset.func_177952_p(), this.x2 + offset.func_177958_n(), this.z2 + offset.func_177952_p());
    }

    public BoundingBox offsetNegative(BlockPos offset) {
        return new BoundingBox(this.x1 - offset.func_177958_n(), this.z1 - offset.func_177952_p(), this.x2 - offset.func_177958_n(), this.z2 - offset.func_177952_p());
    }

    public String toString() {
        return this.x1 + " " + this.z1 + " " + this.x2 + " " + this.z2;
    }

    public void rotate(Rotation rotation) {
        BlockPos start = new BlockPos(this.x1, 0, this.z1);
        BlockPos end = new BlockPos(this.x2, 0, this.z2);
        start = start.func_190942_a(rotation);
        end = end.func_190942_a(rotation);
        int nx1 = Math.min(start.func_177958_n(), end.func_177958_n());
        int nx2 = Math.max(start.func_177958_n(), end.func_177958_n());
        int nz1 = Math.min(start.func_177952_p(), end.func_177952_p());
        int nz2 = Math.max(start.func_177952_p(), end.func_177952_p());
        this.x1 = 0;
        this.z1 = 0;
        this.x2 = nx2 - nx1;
        this.z2 = nz2 - nz1;
    }
}

