/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;

public interface IStructureWorld {
    public static final boolean doBlockNotify = false;

    public void generate(World var1, BlockPos var2, Rotation var3);

    default public void setBlockAndNotifyAdequately(World world, BlockPos pos, IBlockState state) {
        int flag = ForgeModContainer.fixVanillaCascading ? 18 : 2;
        world.func_180501_a(pos, state, flag);
    }

    default public boolean isTopSolid(World world, BlockPos pos) {
        return world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
    }

    default public float getAirFraction(World world, BlockPos pos, Rotation rotation) {
        return 1.0f;
    }

    default public void generateSurface(World world, BlockPos pos, Random random) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        if ((double)this.getAirFraction(world, pos, rotation) > 0.8) {
            this.generate(world, pos, rotation);
        }
    }

    default public void generateSubterrain(World world, BlockPos pos, Random random) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        if ((double)this.getAirFraction(world, pos, rotation) < 0.4) {
            this.generate(world, pos, rotation);
        }
    }
}

