/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.events;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import paulevs.betternether.blocks.BlockBrownLargeMushroom;
import paulevs.betternether.blocks.BlockRedLargeMushroom;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.world.BNWorldGenerator;

public class EventsHandler {
    static NoiseGeneratorOctaves featureScatter;
    private static boolean worldLoaded;

    public static void init() {
        featureScatter = new NoiseGeneratorOctaves(new Random(1337L), 3);
        worldLoaded = false;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!worldLoaded && event.getWorld().field_73011_w.func_186058_p() == DimensionType.NETHER) {
            BNWorldGenerator.init(event.getWorld().func_72905_C());
            worldLoaded = true;
        }
    }

    @SubscribeEvent
    public void onPopulate(PopulateChunkEvent.Post event) {
        if (event.getWorld().field_73011_w.func_186058_p() == DimensionType.NETHER) {
            Random random = event.getRand();
            World world = event.getWorld();
            Chunk chunk = world.func_72964_e(event.getChunkX(), event.getChunkZ());
            BNWorldGenerator.generate(world, chunk, world.field_73012_v);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPrePopulate(PopulateChunkEvent.Pre event) {
        if (event.getWorld().field_73011_w.func_186058_p() == DimensionType.NETHER) {
            Chunk chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ());
            BNWorldGenerator.smoothChunk(chunk);
        }
    }

    @SubscribeEvent
    public void boneGrow(BonemealEvent event) {
        BlockPos pos;
        Block block = event.getBlock().func_177230_c();
        World world = event.getWorld();
        Random random = world.field_73012_v;
        if (!world.field_72995_K && block instanceof BlockNetherrack) {
            IBlockState grass = BlocksRegister.BLOCK_NETHER_GRASS.func_176223_P();
            IBlockState moss = BlocksRegister.BLOCK_NETHERRACK_MOSS.func_176223_P();
            BlockPos bpos = event.getPos();
            if (world.func_180495_p(bpos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(bpos.func_177984_a(), grass);
                block0: for (int i = 0; i < 32; ++i) {
                    int x = bpos.func_177958_n() + (int)(random.nextGaussian() * 2.0);
                    int z = bpos.func_177952_p() + (int)(random.nextGaussian() * 2.0);
                    int y = bpos.func_177956_o() + random.nextInt(6);
                    for (int j = 0; j < 6; ++j) {
                        BlockPos pos2 = new BlockPos(x, y - j, z);
                        Block top = world.func_180495_p(pos2).func_177230_c();
                        Block bottom = world.func_180495_p(pos2.func_177977_b()).func_177230_c();
                        if (top != Blocks.field_150350_a || !(bottom instanceof BlockNetherrack)) continue;
                        world.func_175656_a(pos2, grass);
                        if (random.nextInt(2) != 0) continue block0;
                        world.func_175656_a(pos2.func_177977_b(), moss);
                        continue block0;
                    }
                }
                event.setResult(Event.Result.ALLOW);
            }
        } else if (!world.field_72995_K && block == Blocks.field_150337_Q) {
            BlockPos pos3 = event.getPos();
            if (world.func_180495_p(pos3.func_177977_b()).func_177230_c() == BlocksRegister.BLOCK_NETHER_MYCELIUM) {
                int size = 1 + random.nextInt(3);
                for (int y = 1; y <= size; ++y) {
                    if (world.func_175623_d(pos3.func_177981_b(y))) continue;
                    size = y - 1;
                    break;
                }
                if (size > 1) {
                    event.setResult(Event.Result.ALLOW);
                    if (random.nextInt(4) == 0) {
                        world.func_175698_g(pos3);
                        IBlockState middle = BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)BlockRedLargeMushroom.EnumShape.MIDDLE));
                        for (int y = 1; y < size; ++y) {
                            world.func_180501_a(pos3.func_177981_b(y), middle, 2);
                        }
                        world.func_180501_a(pos3.func_177981_b(size), BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)BlockRedLargeMushroom.EnumShape.TOP)), 2);
                        world.func_180501_a(pos3, BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P(), 2);
                    }
                }
            }
        } else if (!world.field_72995_K && block == Blocks.field_150338_P && world.func_180495_p((pos = event.getPos()).func_177977_b()).func_177230_c() == BlocksRegister.BLOCK_NETHER_MYCELIUM) {
            int size = 1 + random.nextInt(3);
            for (int y = 1; y <= size; ++y) {
                if (world.func_175623_d(pos.func_177981_b(y))) continue;
                size = y - 1;
                break;
            }
            if (size > 1) {
                event.setResult(Event.Result.ALLOW);
                if (random.nextInt(4) == 0) {
                    world.func_175698_g(pos);
                    IBlockState middle = BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.MIDDLE));
                    world.func_180501_a(pos, BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P(), 2);
                    for (int y = 1; y < size; ++y) {
                        world.func_180501_a(pos.func_177981_b(y), middle, 2);
                    }
                    pos = pos.func_177981_b(size);
                    world.func_180501_a(pos, BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.TOP)), 2);
                    if (world.func_175623_d(pos.func_177978_c())) {
                        world.func_180501_a(pos.func_177978_c(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.SIDE_N)), 2);
                    }
                    if (world.func_175623_d(pos.func_177968_d())) {
                        world.func_180501_a(pos.func_177968_d(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.SIDE_S)), 2);
                    }
                    if (world.func_175623_d(pos.func_177974_f())) {
                        world.func_180501_a(pos.func_177974_f(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.SIDE_E)), 2);
                    }
                    if (world.func_175623_d(pos.func_177976_e())) {
                        world.func_180501_a(pos.func_177976_e(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.SIDE_W)), 2);
                    }
                    if (world.func_175623_d(pos.func_177978_c().func_177974_f())) {
                        world.func_180501_a(pos.func_177978_c().func_177974_f(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.CORNER_N)), 2);
                    }
                    if (world.func_175623_d(pos.func_177978_c().func_177976_e())) {
                        world.func_180501_a(pos.func_177978_c().func_177976_e(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.CORNER_W)), 2);
                    }
                    if (world.func_175623_d(pos.func_177968_d().func_177974_f())) {
                        world.func_180501_a(pos.func_177968_d().func_177974_f(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.CORNER_E)), 2);
                    }
                    if (world.func_175623_d(pos.func_177968_d().func_177976_e())) {
                        world.func_180501_a(pos.func_177968_d().func_177976_e(), BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.EnumShape.CORNER_S)), 2);
                    }
                }
            }
        }
    }
}

