/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import paulevs.betternether.blocks.BlocksRegister;

public class BlockStalagnateBase
extends Block {
    private static final AxisAlignedBB COLLIDE_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB SELECT_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockStalagnateBase() {
        super(Material.field_151575_d, MapColor.field_193566_R);
        this.func_149663_c("stalagnate");
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLIDE_AABB;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SELECT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return side != EnumFacing.UP && side != EnumFacing.DOWN || iblockstate != blockState;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlocksRegister.BLOCK_STALAGNATE_STEM);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(BlocksRegister.BLOCK_STALAGNATE_STEM);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_73012_v.nextInt(4) == 0) {
            this.spawnSeeds(worldIn, pos);
        }
        worldIn.func_175655_b(pos, true);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (worldIn.field_73012_v.nextInt(4) == 0) {
            this.spawnSeeds(worldIn, pos);
        }
        worldIn.func_175655_b(pos, true);
    }

    private void spawnSeeds(World world, BlockPos pos) {
        ItemStack drop = new ItemStack(BlocksRegister.BLOCK_STALAGNATE_SEED, 1);
        EntityItem itemEntity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
        world.func_72838_d((Entity)itemEntity);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THICK : BlockFaceShape.CENTER_BIG;
    }
}

