/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import java.util.Random;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.blocks.BlockRedLargeMushroom;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.world.BNWorldGenerator;

public class NetherMushroomForest
extends NetherBiome {
    public NetherMushroomForest(String name) {
        super(name);
    }

    @Override
    public void genSurfColumn(Chunk chunk, BlockPos pos, Random random) {
        if (chunk.func_177435_g(pos).func_177230_c() == Blocks.field_150424_aL) {
            switch (random.nextInt(10)) {
                case 0: {
                    chunk.func_177436_a(pos, Blocks.field_150425_aM.func_176223_P());
                    chunk.func_177436_a(pos.func_177984_a(), Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(random.nextInt(4))));
                    break;
                }
                default: {
                    if (BlocksRegister.BLOCK_NETHER_MYCELIUM != Blocks.field_150350_a) {
                        chunk.func_177436_a(pos, BlocksRegister.BLOCK_NETHER_MYCELIUM.func_176223_P());
                        break;
                    }
                    chunk.func_177436_a(pos, Blocks.field_150391_bh.func_176223_P());
                }
            }
            for (int i = 1; i < 1 + random.nextInt(3); ++i) {
                BlockPos p2 = pos.func_177979_c(i);
                if (p2.func_177956_o() <= -1 || random.nextInt(3) != 0 || chunk.func_177435_g(p2).func_177230_c() != Blocks.field_150424_aL) continue;
                chunk.func_177436_a(p2, Blocks.field_150425_aM.func_176223_P());
            }
        }
    }

    @Override
    public void genFloorObjects(Chunk chunk, BlockPos pos, Random random) {
        if (random.nextFloat() <= this.plantDensity && chunk.func_177435_g(pos).func_177230_c() == BlocksRegister.BLOCK_NETHER_MYCELIUM || chunk.func_177435_g(pos).func_177230_c() == Blocks.field_150391_bh) {
            if (BNWorldGenerator.hasRedMushroomGen && random.nextInt(7) == 0) {
                BNWorldGenerator.redMushroomGen.generate(chunk, pos, random);
            } else if (BNWorldGenerator.hasBrownMushroomGen && random.nextInt(6) == 0) {
                BNWorldGenerator.brownMushroomGen.generate(chunk, pos, random);
            } else if (BNWorldGenerator.hasOrangeMushroomGen && random.nextInt(20) == 0) {
                BNWorldGenerator.orangeMushroomGen.generate(chunk, pos, random);
            } else if (BNWorldGenerator.hasRedMoldGen && random.nextInt(12) == 0) {
                BNWorldGenerator.redMoldGen.generate(chunk, pos, random);
            } else if (BNWorldGenerator.hasGrayMoldGen && random.nextInt(10) == 0) {
                BNWorldGenerator.grayMoldGen.generate(chunk, pos, random);
            } else if (random.nextInt(3) == 0) {
                if (random.nextBoolean()) {
                    chunk.func_177436_a(pos.func_177984_a(), Blocks.field_150337_Q.func_176223_P());
                } else {
                    chunk.func_177436_a(pos.func_177984_a(), Blocks.field_150338_P.func_176223_P());
                }
            }
        }
    }

    @Override
    public void genWallObjects(Chunk chunk, BlockPos origin, BlockPos pos, Random random) {
        if (random.nextFloat() <= this.plantDensity && BNWorldGenerator.hasLucisGen && random.nextInt(4) == 0 && chunk.func_177435_g(origin).func_177230_c() == Blocks.field_150424_aL) {
            BNWorldGenerator.lucisGen.generate(chunk, pos, random);
        }
    }

    private void growRedMushroom(Chunk chunk, BlockPos pos, Random random) {
        int size = 2 + random.nextInt(3);
        for (int y = 1; y <= size; ++y) {
            if (chunk.func_177435_g(pos.func_177981_b(y)).func_177230_c() == Blocks.field_150350_a) continue;
            size = y;
            break;
        }
        if (size > 2) {
            IBlockState middle = BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)BlockRedLargeMushroom.EnumShape.MIDDLE));
            for (int y = 2; y < size; ++y) {
                chunk.func_177436_a(pos.func_177981_b(y), middle);
            }
            chunk.func_177436_a(pos.func_177981_b(size), BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P().func_177226_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)BlockRedLargeMushroom.EnumShape.TOP)));
            chunk.func_177436_a(pos.func_177984_a(), BlocksRegister.BLOCK_RED_LARGE_MUSHROOM.func_176223_P());
        }
    }
}

