/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.structures.StructureReeds;
import paulevs.betternether.world.BNWorldGenerator;

public class NetherGrasslands
extends NetherBiome {
    public NetherGrasslands(String name) {
        super(name);
    }

    @Override
    public void genFloorObjects(Chunk chunk, BlockPos pos, Random random) {
        Block ground = chunk.func_177435_g(pos).func_177230_c();
        if (random.nextFloat() <= this.plantDensity && ground instanceof BlockNetherrack || ground == Blocks.field_150425_aM) {
            boolean reeds = false;
            if (BlocksRegister.BLOCK_NETHER_REED != Blocks.field_150350_a && random.nextInt(4) == 0) {
                reeds = StructureReeds.generate(chunk, pos, random);
            }
            if (!reeds) {
                if (BNWorldGenerator.hasWartTreeGen && ground == Blocks.field_150425_aM && random.nextInt(2) == 0) {
                    chunk.func_177436_a(pos.func_177984_a(), Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(random.nextInt(4))));
                } else if (BNWorldGenerator.hasMagmaFlowerGen && pos.func_177956_o() < 37 && pos.func_177956_o() > 23 && random.nextInt(32) == 0) {
                    BNWorldGenerator.magmaFlowerGen.generate(chunk, pos, random);
                } else if (BNWorldGenerator.hasSmokerGen && random.nextInt(16) == 0) {
                    BNWorldGenerator.smokerGen.generate(chunk, pos, random);
                } else if (BNWorldGenerator.hasInkBushGen && random.nextInt(16) == 0) {
                    BNWorldGenerator.inkBushGen.generate(chunk, pos, random);
                } else if (BNWorldGenerator.hasEggPlantGen && random.nextInt(16) == 0) {
                    BNWorldGenerator.eggPlantGen.generate(chunk, pos, random);
                } else if (BNWorldGenerator.hasBlackAppleGen && random.nextInt(16) == 0) {
                    BNWorldGenerator.blackAppleGen.generate(chunk, pos, random);
                } else if (BlocksRegister.BLOCK_BLACK_BUSH != Blocks.field_150350_a && random.nextInt(6) == 0 && this.getFeatureNoise(pos, chunk.field_76635_g, chunk.field_76635_g) > 0.3) {
                    chunk.func_177436_a(pos.func_177984_a(), BlocksRegister.BLOCK_BLACK_BUSH.func_176223_P());
                } else if (BlocksRegister.BLOCK_WART_SEED != Blocks.field_150350_a && random.nextInt(5) == 0) {
                    chunk.func_177436_a(pos.func_177984_a(), BlocksRegister.BLOCK_WART_SEED.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.UP));
                } else if (BlocksRegister.BLOCK_NETHER_GRASS != Blocks.field_150350_a && random.nextInt(4) != 0) {
                    chunk.func_177436_a(pos.func_177984_a(), BlocksRegister.BLOCK_NETHER_GRASS.func_176223_P());
                }
            }
        }
    }

    @Override
    public void genSurfColumn(Chunk chunk, BlockPos pos, Random random) {
        if (chunk.func_177435_g(pos).func_177230_c() == Blocks.field_150424_aL) {
            if (BlocksRegister.BLOCK_NETHERRACK_MOSS != Blocks.field_150350_a) {
                switch (random.nextInt(3)) {
                    case 0: {
                        chunk.func_177436_a(pos, Blocks.field_150425_aM.func_176223_P());
                        break;
                    }
                    case 1: {
                        chunk.func_177436_a(pos, BlocksRegister.BLOCK_NETHERRACK_MOSS.func_176223_P());
                    }
                }
            } else if (random.nextInt(3) == 0) {
                chunk.func_177436_a(pos, Blocks.field_150425_aM.func_176223_P());
            }
        }
    }
}

