/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.structures.StructureReeds;
import paulevs.betternether.world.BNWorldGenerator;

public class NetherBiomeJungle
extends NetherBiome {
    public NetherBiomeJungle(String name) {
        super(name);
    }

    @Override
    public void genFloorObjects(Chunk chunk, BlockPos pos, Random random) {
        Block ground = chunk.func_177435_g(pos).func_177230_c();
        if (ground instanceof BlockNetherrack || ground == Blocks.field_150425_aM) {
            boolean reeds = false;
            if (BlocksRegister.BLOCK_NETHER_REED != Blocks.field_150350_a && random.nextInt(4) == 0) {
                reeds = StructureReeds.generate(chunk, pos, random);
            }
            if (!reeds) {
                if (BNWorldGenerator.hasEyeGen && random.nextInt(8) == 0) {
                    BNWorldGenerator.stalagnateGen.generate(chunk, pos, random);
                } else if (BNWorldGenerator.hasMagmaFlowerGen && pos.func_177956_o() < 37 && pos.func_177956_o() > 23 && random.nextInt(32) == 0) {
                    BNWorldGenerator.magmaFlowerGen.generate(chunk, pos, random);
                } else if (BNWorldGenerator.hasEggPlantGen && random.nextInt(16) == 0) {
                    BNWorldGenerator.eggPlantGen.generate(chunk, pos, random);
                } else if (BlocksRegister.BLOCK_NETHER_GRASS != Blocks.field_150350_a && random.nextInt(3) != 0) {
                    chunk.func_177436_a(pos.func_177984_a(), BlocksRegister.BLOCK_NETHER_GRASS.func_176223_P());
                }
            }
        }
    }

    @Override
    public void genWallObjects(Chunk chunk, BlockPos origin, BlockPos pos, Random random) {
        if (random.nextFloat() <= this.plantDensity && BNWorldGenerator.hasLucisGen && random.nextInt(4) == 0 && chunk.func_177435_g(origin).func_177230_c() == Blocks.field_150424_aL) {
            BNWorldGenerator.lucisGen.generate(chunk, pos, random);
        }
    }

    @Override
    public void genCeilObjects(Chunk chunk, BlockPos pos, Random random) {
        if (random.nextFloat() <= this.plantDensity && BNWorldGenerator.hasEyeGen && random.nextInt(8) == 0 && random.nextDouble() * 4.0 + 0.5 < this.getFeatureNoise(pos, chunk.field_76635_g, chunk.field_76647_h)) {
            BNWorldGenerator.eyeGen.generate(chunk, pos.func_177977_b(), random);
        }
    }

    @Override
    public void genSurfColumn(Chunk chunk, BlockPos pos, Random random) {
        if (random.nextFloat() <= this.plantDensity && chunk.func_177435_g(pos).func_177230_c() == Blocks.field_150424_aL) {
            if (BlocksRegister.BLOCK_NETHERRACK_MOSS != Blocks.field_150350_a) {
                switch (random.nextInt(3)) {
                    case 0: {
                        chunk.func_177436_a(pos, Blocks.field_150425_aM.func_176223_P());
                        break;
                    }
                    case 1: {
                        chunk.func_177436_a(pos, BlocksRegister.BLOCK_NETHERRACK_MOSS.func_176223_P());
                    }
                }
            } else if (random.nextInt(3) == 0) {
                chunk.func_177436_a(pos, Blocks.field_150425_aM.func_176223_P());
            }
        }
    }
}

