/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.world.gen;

import hmysjiang.usefulstuffs.ConfigManager;
import hmysjiang.usefulstuffs.blocks.bush.BlockBerryBush;
import hmysjiang.usefulstuffs.init.ModBlocks;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BerryBushGenerator
implements IWorldGenerator {
    private static final int bush_min_h = ConfigManager.bushSpawnMinHeight;
    public static final int[] BANNED_BIOME_IDS = ConfigManager.bush_banned_biomes;
    public static final int[] BANNED_DIM_IDS = ConfigManager.bush_banned_dims;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Biome biome = world.func_180494_b(new BlockPos(chunkX * 16, 64, chunkZ * 16));
        if (BerryBushGenerator.canGenInWorld(world) && BerryBushGenerator.canGenInBiome(world.func_180494_b(new BlockPos(chunkX * 16, 64, chunkZ * 16))) && random.nextInt(ConfigManager.bushSpawnRate) == 0) {
            int centerX = chunkX * 16 + random.nextInt(10) + 3;
            int centerZ = chunkZ * 16 + random.nextInt(10) + 3;
            int bushes = random.nextInt(4) + 4;
            while (bushes-- > 0) {
                int z;
                int x = centerX + (int)(random.nextGaussian() * 2.0);
                BlockPos pos = world.func_175672_r(new BlockPos(x, 0, z = centerZ + (int)(random.nextGaussian() * 2.0)));
                if (pos.func_177956_o() < bush_min_h) continue;
                while (world.func_180495_p(pos).func_177230_c() instanceof BlockBerryBush) {
                    pos = pos.func_177984_a();
                }
                if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || !ModBlocks.berrybushes[0].func_176196_c(world, pos)) continue;
                world.func_175656_a(pos, ((BlockBerryBush)ModBlocks.berrybushes[random.nextInt(16)]).getRandomSpawnState(random));
            }
        }
    }

    public static boolean canGenInWorld(World world) {
        int id = world.field_73011_w.getDimension();
        for (int i : BANNED_DIM_IDS) {
            if (i != id) continue;
            return false;
        }
        return true;
    }

    public static boolean canGenInBiome(Biome biome) {
        int id = Biome.func_185362_a((Biome)biome);
        for (int i : BANNED_BIOME_IDS) {
            if (i != id) continue;
            return false;
        }
        return true;
    }
}

