/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.utils.helper;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.IItemHandler;

public class WorldHelper {
    public static World getServerWorldFromId(int id) {
        for (WorldServer world : DimensionManager.getWorlds()) {
            if (world.field_73011_w.getDimension() != id) continue;
            return world;
        }
        return null;
    }

    public static EnumFacing getRelationBetweenAdjacentBlocks(BlockPos dominant, BlockPos recessive) {
        if (dominant.func_177958_n() != recessive.func_177958_n()) {
            if (dominant.func_177956_o() != recessive.func_177956_o() || dominant.func_177952_p() != recessive.func_177952_p()) {
                return null;
            }
            if (dominant.func_177958_n() > recessive.func_177958_n()) {
                return EnumFacing.WEST;
            }
            return EnumFacing.EAST;
        }
        if (dominant.func_177956_o() != recessive.func_177956_o()) {
            if (dominant.func_177958_n() != recessive.func_177958_n() || dominant.func_177952_p() != recessive.func_177952_p()) {
                return null;
            }
            if (dominant.func_177956_o() > recessive.func_177956_o()) {
                return EnumFacing.DOWN;
            }
            return EnumFacing.UP;
        }
        if (dominant.func_177952_p() != recessive.func_177952_p()) {
            if (dominant.func_177958_n() != recessive.func_177958_n() || dominant.func_177956_o() != recessive.func_177956_o()) {
                return null;
            }
            if (dominant.func_177952_p() > recessive.func_177952_p()) {
                return EnumFacing.NORTH;
            }
            return EnumFacing.SOUTH;
        }
        return null;
    }

    public static boolean isRelationCorrect(BlockPos dominant, BlockPos recessive, EnumFacing relation, boolean collideCount) {
        switch (relation.func_176740_k()) {
            case X: {
                if (dominant.func_177958_n() == recessive.func_177958_n()) {
                    return collideCount;
                }
                if (dominant.func_177958_n() > recessive.func_177958_n() && relation == EnumFacing.WEST) {
                    return true;
                }
                return dominant.func_177958_n() < recessive.func_177958_n() && relation == EnumFacing.EAST;
            }
            case Y: {
                if (dominant.func_177956_o() == recessive.func_177956_o()) {
                    return collideCount;
                }
                if (dominant.func_177956_o() > recessive.func_177956_o() && relation == EnumFacing.DOWN) {
                    return true;
                }
                return dominant.func_177956_o() < recessive.func_177956_o() && relation == EnumFacing.UP;
            }
            case Z: {
                if (dominant.func_177952_p() == recessive.func_177952_p()) {
                    return collideCount;
                }
                if (dominant.func_177952_p() > recessive.func_177952_p() && relation == EnumFacing.NORTH) {
                    return true;
                }
                return dominant.func_177952_p() < recessive.func_177952_p() && relation == EnumFacing.SOUTH;
            }
        }
        return false;
    }

    public static float getBlockDataDensity(World world, BlockPos pos, IBlockState state, TileEntity tile) {
        float den = 0.0f;
        if (state != null) {
            float hardness = state.func_185887_b(world, pos);
            den = (float)((double)den + Math.log10(hardness + 2.0f) / 0.7 * 10.0);
            ImmutableMap properties = state.func_177228_b();
            for (IProperty property : properties.keySet()) {
                if (property instanceof PropertyBool) {
                    den += 1.0f;
                    continue;
                }
                if (property instanceof PropertyInteger) {
                    den += 2.0f;
                    continue;
                }
                if (property instanceof PropertyDirection) {
                    den += 3.0f;
                    continue;
                }
                den += 4.0f;
            }
            if (tile != null) {
                den *= 2.0f;
            }
        }
        return den;
    }

    public static void spawnItemsInHandler(World world, int x, int y, int z, @Nonnull IItemHandler handler) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, handler.getStackInSlot(i).func_77946_l()));
        }
    }

    public static RayTraceResult rayTrace(EntityLivingBase living, int maxRange) {
        Vec3d prev = living.func_174791_d().func_178787_e(new Vec3d(0.0, (double)living.func_70047_e(), 0.0));
        Vec3d startPos = new Vec3d(prev.field_72450_a, prev.field_72448_b, prev.field_72449_c);
        Vec3d gaze = living.func_70040_Z().func_186678_a(0.05);
        for (int i = 1; i <= maxRange * 20; ++i) {
            Vec3d pos = startPos.func_178787_e(gaze.func_186678_a((double)i));
            if (!living.field_70170_p.func_175697_a(new BlockPos(pos), 1)) {
                return null;
            }
            if (living.field_70170_p.func_180495_p(new BlockPos(pos)).func_185904_a() != Material.field_151579_a) {
                if (WorldHelper.getRelationBetweenAdjacentBlocks(new BlockPos(pos), new BlockPos(prev)) == null) {
                    return null;
                }
                return new RayTraceResult(pos, WorldHelper.getRelationBetweenAdjacentBlocks(new BlockPos(pos), new BlockPos(prev)), new BlockPos(pos));
            }
            if (pos.equals((Object)prev)) continue;
            prev = startPos.func_178787_e(gaze.func_186678_a((double)i));
        }
        return null;
    }

    public static int getDistanceProjctedOnAxis(BlockPos pos1, BlockPos pos2, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return Math.abs(pos1.func_177958_n() - pos2.func_177958_n());
            }
            case Y: {
                return Math.abs(pos1.func_177956_o() - pos2.func_177956_o());
            }
            case Z: {
                return Math.abs(pos1.func_177952_p() - pos2.func_177952_p());
            }
        }
        return 0;
    }

    public static EntityLivingBase rayTraceEntity(EntityLivingBase source) {
        Vec3d pos = source.func_174824_e(1.0f);
        Vec3d gaze = source.func_70040_Z().func_72432_b().func_186678_a(0.1);
        for (int i = 1; i <= 30; ++i) {
            Vec3d p = pos.func_178787_e(gaze.func_186678_a((double)i));
            for (EntityLivingBase living : source.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(new BlockPos(p)).func_186662_g(1.0))) {
                if (!living.func_174813_aQ().func_72318_a(p)) continue;
                return living;
            }
        }
        return null;
    }

    public static EntityLivingBase rayTraceEntity(World world, BlockPos pos, EnumFacing facing, double blockDistance) {
        Vec3d posv = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
        Vec3d gaze = new Vec3d(facing.func_176730_m()).func_186678_a(0.1);
        for (int i = 1; i <= (int)(blockDistance * 10.0); ++i) {
            Vec3d p = posv.func_178787_e(gaze.func_186678_a((double)i));
            for (EntityLivingBase living : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(new BlockPos(p)).func_186662_g(1.0))) {
                if (!living.func_174813_aQ().func_72318_a(p)) continue;
                return living;
            }
        }
        return null;
    }

    public static Vec3d getHitVecFromAdjacent(EnumFacing directionTo) {
        return new Vec3d(0.5, 0.5, 0.5).func_178788_d(new Vec3d(directionTo.func_176730_m()).func_186678_a(0.5));
    }
}

