/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.utils.capabilities;

import hmysjiang.usefulstuffs.items.ItemTankContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CapabilityFluidItemStack
implements ICapabilityProvider {
    final ItemStack stack;

    public CapabilityFluidItemStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)new IFluidHandlerItem(){

                public IFluidTankProperties[] getTankProperties() {
                    return new IFluidTankProperties[]{new FluidTankProperties(ItemTankContainer.getFluid(CapabilityFluidItemStack.this.stack), ItemTankContainer.getCapacity(CapabilityFluidItemStack.this.stack))};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (resource == null) {
                        return 0;
                    }
                    int cap = ItemTankContainer.getCapacity(CapabilityFluidItemStack.this.stack);
                    if (ItemTankContainer.getFluid(CapabilityFluidItemStack.this.stack) == null || ItemTankContainer.getFluid(CapabilityFluidItemStack.this.stack).isFluidEqual(resource)) {
                        FluidStack destination = ItemTankContainer.getFluid(CapabilityFluidItemStack.this.stack);
                        if (destination != null) {
                            int space = cap - destination.amount;
                            if (doFill) {
                                destination.amount = destination.amount + (resource.amount > space ? space : resource.amount);
                                ItemTankContainer.setFluid(CapabilityFluidItemStack.this.stack, destination);
                            }
                            return resource.amount > space ? space : resource.amount;
                        }
                        if (doFill) {
                            FluidStack newFluid = resource.copy();
                            newFluid.amount = resource.amount > cap ? cap : resource.amount;
                            ItemTankContainer.setFluid(CapabilityFluidItemStack.this.stack, newFluid);
                        }
                        return resource.amount > cap ? cap : resource.amount;
                    }
                    if (ItemTankContainer.getFluid((ItemStack)CapabilityFluidItemStack.this.stack).amount == 0) {
                        if (doFill) {
                            FluidStack newFluid = resource.copy();
                            newFluid.amount = resource.amount > cap ? cap : resource.amount;
                            ItemTankContainer.setFluid(CapabilityFluidItemStack.this.stack, resource);
                        }
                        return resource.amount > cap ? cap : resource.amount;
                    }
                    return 0;
                }

                public FluidStack drain(int maxDrain, boolean doDrain) {
                    FluidStack fluid = ItemTankContainer.getFluid(CapabilityFluidItemStack.this.stack);
                    if (fluid == null) {
                        return null;
                    }
                    int amount = fluid.amount;
                    int n = fluid.amount = maxDrain > fluid.amount ? fluid.amount : maxDrain;
                    if (doDrain) {
                        ItemTankContainer.setFluid(CapabilityFluidItemStack.this.stack, new FluidStack(fluid, amount - fluid.amount));
                    }
                    return fluid;
                }

                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (ItemTankContainer.getFluid(CapabilityFluidItemStack.this.stack) != null && ItemTankContainer.getFluid(CapabilityFluidItemStack.this.stack).isFluidEqual(resource)) {
                        return this.drain(resource.amount, doDrain);
                    }
                    return null;
                }

                public ItemStack getContainer() {
                    return CapabilityFluidItemStack.this.stack;
                }
            };
        }
        return null;
    }
}

