/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.network.packet;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlaySound
implements IMessage {
    public int playerEntId;
    public int x;
    public int y;
    public int z;
    public float volume;
    public float pitch;
    public int resourceLength;
    public int categoryLength;
    public String resource;
    public String category;

    public PlaySound() {
    }

    public PlaySound(int playerEntityId, BlockPos pos, ResourceLocation sound, SoundCategory category, float volume, float pitch) {
        this.playerEntId = playerEntityId;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.volume = volume;
        this.pitch = pitch;
        this.resource = sound.toString();
        this.resourceLength = this.resource.length();
        this.category = category.func_187948_a();
        this.categoryLength = this.category.length();
    }

    public void fromBytes(ByteBuf buf) {
        this.playerEntId = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.resourceLength = buf.readInt();
        this.categoryLength = buf.readInt();
        this.resource = (String)buf.readCharSequence(this.resourceLength, StandardCharsets.UTF_8);
        this.category = (String)buf.readCharSequence(this.categoryLength, StandardCharsets.UTF_8);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.playerEntId);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeInt(this.resourceLength);
        buf.writeInt(this.categoryLength);
        buf.writeCharSequence((CharSequence)this.resource, StandardCharsets.UTF_8);
        buf.writeCharSequence((CharSequence)this.category, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<PlaySound, IMessage> {
        public IMessage onMessage(PlaySound message, MessageContext ctx) {
            Entity player;
            SoundCategory category;
            SoundEvent event;
            if (message != null && (event = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(message.resource))) != null && (category = SoundCategory.func_187950_a((String)message.category)) != null && (player = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.playerEntId)) != null && player instanceof EntityPlayer) {
                Minecraft.func_71410_x().field_71441_e.func_184133_a((EntityPlayer)player, new BlockPos(message.x, message.y, message.z), event, category, message.volume, message.pitch);
            }
            return null;
        }
    }
}

