/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.network.packet;

import hmysjiang.usefulstuffs.items.baubles.ItemMiningBackpack;
import hmysjiang.usefulstuffs.utils.helper.WorldHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BackpackPropertyUpdate
implements IMessage {
    public int worldId;
    public int playerId;
    public boolean auto;
    public boolean quickDepo;

    public BackpackPropertyUpdate() {
    }

    public BackpackPropertyUpdate(World world, EntityPlayer player, boolean auto, boolean quickDepo) {
        this.worldId = world.field_73011_w.getDimension();
        this.playerId = player.func_145782_y();
        this.auto = auto;
        this.quickDepo = quickDepo;
    }

    public void fromBytes(ByteBuf buf) {
        this.worldId = buf.readInt();
        this.playerId = buf.readInt();
        this.auto = buf.readBoolean();
        this.quickDepo = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.worldId);
        buf.writeInt(this.playerId);
        buf.writeBoolean(this.auto);
        buf.writeBoolean(this.quickDepo);
    }

    public static class Handler
    implements IMessageHandler<BackpackPropertyUpdate, IMessage> {
        public IMessage onMessage(BackpackPropertyUpdate message, MessageContext ctx) {
            if (message != null) {
                World world = WorldHelper.getServerWorldFromId(message.worldId);
                if (world == null) {
                    return null;
                }
                EntityPlayer player = (EntityPlayer)world.func_73045_a(message.playerId);
                if (player == null) {
                    return null;
                }
                ItemStack stack = player.func_184614_ca();
                ItemMiningBackpack.updateProperties(stack, message.auto, message.quickDepo);
            }
            return null;
        }
    }
}

