/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.items.baubles;

import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import hmysjiang.usefulstuffs.ConfigManager;
import hmysjiang.usefulstuffs.Reference;
import hmysjiang.usefulstuffs.UsefulStuffs;
import hmysjiang.usefulstuffs.init.ModItems;
import hmysjiang.usefulstuffs.items.baubles.ItemBackpack;
import hmysjiang.usefulstuffs.network.PacketHandler;
import hmysjiang.usefulstuffs.network.packet.PlaySound;
import hmysjiang.usefulstuffs.utils.handler.KeyBindingHandler;
import hmysjiang.usefulstuffs.utils.helper.OreDictHelper;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber
public class ItemMiningBackpack
extends ItemBackpack {
    public static void setDefaultTag(ItemStack stack) {
        ItemStackHandler emptyHandler;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("Cont")) {
            emptyHandler = new ItemStackHandler(54);
            stack.func_77978_p().func_74782_a("Cont", (NBTBase)emptyHandler.serializeNBT());
        }
        if (!stack.func_77978_p().func_74764_b("Filter")) {
            emptyHandler = new ItemStackHandler(18);
            stack.func_77978_p().func_74782_a("Filter", (NBTBase)emptyHandler.serializeNBT());
        }
        if (!stack.func_77978_p().func_74764_b("QuickDepo")) {
            stack.func_77978_p().func_74757_a("QuickDepo", false);
        }
        if (!stack.func_77978_p().func_74764_b("Auto")) {
            stack.func_77978_p().func_74757_a("Auto", true);
        }
    }

    public static void updateProperties(ItemStack stack, boolean auto, boolean quickDepo) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("Auto", auto);
        stack.func_77978_p().func_74757_a("QuickDepo", quickDepo);
    }

    @SubscribeEvent
    public static void onPlayerPickUp(EntityItemPickupEvent event) {
        if (ConfigManager.miningBackpackEnabled && event.getEntityPlayer() != null) {
            ItemStack stack = event.getItem().func_92059_d().func_77946_l();
            EntityPlayer player = event.getEntityPlayer();
            if (((IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)).getStackInSlot(5).func_77973_b() == ModItems.mining_backpack) {
                ItemStack backpack = ((IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)).getStackInSlot(5);
                if (backpack.func_77978_p() == null) {
                    ItemMiningBackpack.setDefaultTag(backpack);
                }
                if (backpack.func_77978_p().func_74767_n("Auto")) {
                    ItemStackHandler filter = new ItemStackHandler(18);
                    filter.deserializeNBT(backpack.func_77978_p().func_74775_l("Filter"));
                    if (ItemMiningBackpack.preCheck(stack, filter)) {
                        return;
                    }
                    if (ItemMiningBackpack.check(stack) || ItemMiningBackpack.postCheck(stack, filter)) {
                        ItemStackHandler handler = new ItemStackHandler(54);
                        handler.deserializeNBT(backpack.func_77978_p().func_74775_l("Cont"));
                        for (int i = 0; i < handler.getSlots() && (stack = handler.insertItem(i, stack.func_77946_l(), false)).func_190916_E() != 0; ++i) {
                        }
                        event.getItem().func_92059_d().func_190920_e(stack.func_190916_E());
                        if (stack.func_190916_E() == 0) {
                            PacketHandler.INSTANCE.sendTo((IMessage)new PlaySound(player.func_145782_y(), player.func_180425_c(), SoundEvents.field_187638_cR.getRegistryName(), SoundCategory.PLAYERS, 0.2f, (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 1.4f + 2.0f), (EntityPlayerMP)player);
                        }
                        backpack.func_77978_p().func_74782_a("Cont", (NBTBase)handler.serializeNBT());
                        return;
                    }
                }
            }
        }
    }

    private static boolean preCheck(ItemStack stack, ItemStackHandler filter) {
        for (int i = 9; i < filter.getSlots(); ++i) {
            if (!stack.func_77969_a(filter.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean check(ItemStack stack) {
        if (OreDictHelper.isRegisterOre(stack)) {
            return true;
        }
        String registryName = stack.func_77973_b().getRegistryName().func_110623_a();
        return registryName.startsWith("ore") || registryName.startsWith("crystal") || registryName.endsWith("ore") || registryName.endsWith("crystal");
    }

    private static boolean postCheck(ItemStack stack, ItemStackHandler filter) {
        for (int i = 0; i < 9; ++i) {
            if (!stack.func_77969_a(filter.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    public ItemMiningBackpack() {
        super(Reference.ModItems.BODY_BACKPACK_MINING.getUnlocalizedName(), Reference.ModItems.BODY_BACKPACK_MINING.getRegistryName());
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Cont")) {
            ItemMiningBackpack.setDefaultTag(stack);
        }
        if (handIn == EnumHand.MAIN_HAND && playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                playerIn.openGui((Object)UsefulStuffs.instance, 15, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            ItemStack backpack = player.func_184586_b(hand);
            if (!backpack.func_77942_o()) {
                ItemMiningBackpack.setDefaultTag(backpack);
            }
            if (backpack.func_77978_p().func_74767_n("QuickDepo")) {
                IItemHandler handler = (IItemHandler)worldIn.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                ItemStackHandler backpackCont = new ItemStackHandler(54);
                backpackCont.deserializeNBT(backpack.func_77978_p().func_74775_l("Cont"));
                for (int i = 0; i < backpackCont.getSlots(); ++i) {
                    ItemStack stack = backpackCont.extractItem(i, 64, false);
                    if (stack.func_190926_b()) continue;
                    for (int j = 0; j < handler.getSlots() && !(stack = handler.insertItem(j, stack.func_77946_l(), false)).func_190926_b(); ++j) {
                    }
                    if (stack.func_190926_b()) continue;
                    backpackCont.insertItem(i, stack, false);
                    break;
                }
                backpack.func_77978_p().func_74782_a("Cont", (NBTBase)backpackCont.serializeNBT());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.backpack.tooltip_mining_1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"usefulstuffs.backpack.tooltip_mining_2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"usefulstuffs.backpack.tooltip", (Object[])new Object[]{KeyBindingHandler.keybindings.get(0).getDisplayName()}));
    }
}

