/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.items;

import hmysjiang.usefulstuffs.Reference;
import hmysjiang.usefulstuffs.UsefulStuffs;
import hmysjiang.usefulstuffs.init.ModBlocks;
import hmysjiang.usefulstuffs.utils.capabilities.CapabilityFluidItemStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTankContainer
extends Item {
    public ItemTankContainer() {
        this.setRegistryName(Reference.ModItems.TANK_CONTAINER.getRegistryName());
        this.func_77655_b(Reference.ModItems.TANK_CONTAINER.getUnlocalizedName());
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74757_a("Place", false);
        } else if (stack.func_77978_p().func_74764_b("Fluid") && stack.func_77978_p().func_74775_l("Fluid").func_74762_e("Amount") == 0) {
            stack.func_77978_p().func_82580_o("Fluid");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                ItemStack tank = playerIn.func_184586_b(handIn);
                if (!tank.func_77942_o()) {
                    tank.func_77982_d(new NBTTagCompound());
                }
                if (!tank.func_77978_p().func_74764_b("Place")) {
                    tank.func_77978_p().func_74757_a("Place", false);
                }
                tank.func_77978_p().func_74757_a("Place", !tank.func_77978_p().func_74767_n("Place"));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(this.execute(playerIn, worldIn, handIn), (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos posIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.execute(player, worldIn, hand);
    }

    private EnumActionResult execute(EntityPlayer player, World worldIn, EnumHand hand) {
        ItemStack tank = player.func_184586_b(hand);
        boolean place = this.isPlaceMode(tank);
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, player, !place);
        if (raytraceresult == null) {
            return EnumActionResult.PASS;
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return EnumActionResult.PASS;
        }
        BlockPos pos = raytraceresult.func_178782_a();
        if (worldIn.func_175660_a(player, pos)) {
            FluidStack drain;
            if (place) {
                RayTraceResult ray2 = this.func_77621_a(worldIn, player, true);
                if (worldIn.func_180495_p(ray2.func_178782_a()).func_177230_c() != ModBlocks.tank && worldIn.func_175625_s(ray2.func_178782_a()) != null && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)worldIn, (BlockPos)ray2.func_178782_a(), (EnumFacing)ray2.field_178784_b)) {
                    return EnumActionResult.SUCCESS;
                }
                boolean replace = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
                BlockPos blockPos = pos = replace && raytraceresult.field_178784_b == EnumFacing.UP ? pos : pos.func_177972_a(raytraceresult.field_178784_b);
                if (!player.func_175151_a(pos, raytraceresult.field_178784_b, tank)) {
                    return EnumActionResult.PASS;
                }
                if (this.placeFluid(worldIn, pos, player, tank)) {
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            if (!player.func_175151_a(pos.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, tank)) {
                return EnumActionResult.PASS;
            }
            IBlockState state = worldIn.func_180495_p(pos);
            BlockLiquidWrapper fluid = null;
            if (state.func_177230_c() instanceof BlockLiquid) {
                fluid = new BlockLiquidWrapper((BlockLiquid)state.func_177230_c(), worldIn, pos);
            } else if (state.func_177230_c() instanceof IFluidBlock) {
                fluid = new FluidBlockWrapper((IFluidBlock)state.func_177230_c(), worldIn, pos);
            }
            if (fluid != null && (drain = fluid.drain(1000, false)) != null && drain.amount == 1000 && this.fillTank(tank, drain)) {
                fluid.drain(1000, true);
                worldIn.func_184133_a(player, pos, drain.getFluid().getFillSound(drain), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    private boolean placeFluid(World worldIn, BlockPos pos, EntityPlayer player, ItemStack tank) {
        boolean notSolid;
        FluidStack fluid;
        if (!tank.func_77942_o()) {
            tank.func_77982_d(new NBTTagCompound());
        }
        if ((fluid = ItemTankContainer.getFluid(tank)) == null || fluid.amount < 1000) {
            return false;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        boolean bl = notSolid = !state.func_185904_a().func_76220_a();
        if (!worldIn.func_175623_d(pos) && !notSolid) {
            return false;
        }
        if (state.func_177230_c() instanceof IFluidBlock && ((IFluidBlock)state.func_177230_c()).canDrain(worldIn, pos)) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockLiquid && new BlockLiquidWrapper((BlockLiquid)state.func_177230_c(), worldIn, pos).drain(1000, false) != null) {
            return false;
        }
        if (fluid.getFluid().canBePlacedInWorld()) {
            if (fluid.getFluid().doesVaporize(fluid) && worldIn.field_73011_w.func_177500_n()) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                worldIn.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int i = 0; i < 8; ++i) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x + Math.random(), (double)i + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                if (!worldIn.field_72995_K && notSolid && !state.func_185904_a().func_76224_d()) {
                    worldIn.func_175655_b(pos, true);
                }
                worldIn.func_184133_a(player, pos, fluid.getFluid().getFillSound(fluid), SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_180501_a(pos, fluid.getFluid().getBlock().func_176223_P(), 11);
                if (pos.func_177956_o() > 0) {
                    worldIn.func_190524_a(pos, fluid.getFluid().getBlock(), pos.func_177977_b());
                }
            }
            fluid.amount -= 1000;
            ItemTankContainer.setFluid(tank, fluid);
            return true;
        }
        return false;
    }

    private boolean fillTank(ItemStack tank, FluidStack fluidStack) {
        FluidStack fluid;
        if (!tank.func_77942_o()) {
            tank.func_77982_d(new NBTTagCompound());
        }
        if ((fluid = ItemTankContainer.getFluid(tank)) == null) {
            fluid = fluidStack.copy();
            fluid.amount = 1000;
            ItemTankContainer.setFluid(tank, fluid);
            return true;
        }
        if (fluidStack.isFluidEqual(fluid)) {
            if (ItemTankContainer.getCapacity(tank) - fluid.amount >= 1000) {
                fluid.amount += 1000;
                ItemTankContainer.setFluid(tank, fluid);
                return true;
            }
        } else if (fluid.amount == 0) {
            FluidStack newFluid = fluidStack.copy();
            newFluid.amount = 1000;
            ItemTankContainer.setFluid(tank, newFluid);
            return true;
        }
        return false;
    }

    private boolean isPlaceMode(ItemStack tank) {
        if (!tank.func_77942_o()) {
            tank.func_77982_d(new NBTTagCompound());
        }
        if (!tank.func_77978_p().func_74764_b("Place")) {
            tank.func_77978_p().func_74757_a("Place", false);
        }
        return tank.func_77978_p().func_74767_n("Place");
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        FluidStack fluid = ItemTankContainer.getFluid(stack);
        int cap = ItemTankContainer.getCapacity(stack);
        int amount = fluid == null ? 0 : fluid.amount;
        return 1.0 - (double)amount / (double)cap;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == UsefulStuffs.TAB) {
            for (TankTier tier : TankTier.values()) {
                if (!tier.availiable()) continue;
                items.add((Object)new ItemStack((Item)this, 1, tier.getMeta()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Place")) {
            if (stack.func_77978_p().func_74767_n("Place")) {
                return this.func_77658_a() + "_" + TankTier.byMeta(stack.func_77960_j()).func_176610_l() + "_place";
            }
            return this.func_77658_a() + "_" + TankTier.byMeta(stack.func_77960_j()).func_176610_l() + "_fill";
        }
        return this.func_77658_a() + "_" + TankTier.byMeta(stack.func_77960_j()).func_176610_l();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_2", (Object[])new Object[0]));
        if (GuiScreen.func_146272_n()) {
            if (stack.func_77942_o()) {
                if (stack.func_77978_p().func_74764_b("Fluid")) {
                    FluidStack fluid = ItemTankContainer.getFluid(stack);
                    if (fluid != null) {
                        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_3", (Object[])new Object[]{fluid.amount > 0 ? fluid.getLocalizedName() : "None"}));
                        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_4", (Object[])new Object[]{fluid.amount, ItemTankContainer.getCapacity(stack)}));
                    } else {
                        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_3", (Object[])new Object[]{"None"}));
                        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_4", (Object[])new Object[]{0, ItemTankContainer.getCapacity(stack)}));
                    }
                } else {
                    tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_3", (Object[])new Object[]{"None"}));
                    tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_4", (Object[])new Object[]{0, ItemTankContainer.getCapacity(stack)}));
                }
                if (stack.func_77978_p().func_74764_b("Place")) {
                    if (stack.func_77978_p().func_74767_n("Place")) {
                        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_5_p", (Object[])new Object[0]));
                    } else {
                        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.tank_container.tooltip_5_f", (Object[])new Object[0]));
                    }
                }
            }
        } else {
            tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)"usefulstuffs.details.tooltip", (Object[])new Object[0]));
        }
    }

    @Nullable
    public static FluidStack getFluid(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid")) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
        }
        return null;
    }

    public static void setFluid(ItemStack stack, @Nullable FluidStack fluid) {
        if (fluid != null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("Fluid")) {
                stack.func_77978_p().func_74782_a("Fluid", (NBTBase)new NBTTagCompound());
            }
            fluid.writeToNBT(stack.func_77978_p().func_74775_l("Fluid"));
        }
    }

    public static int getCapacity(ItemStack stack) {
        return TankTier.getCapacity(stack.func_77960_j());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityFluidItemStack(stack);
    }

    public static enum TankTier implements IStringSerializable
    {
        BASIC(0, 32000, "basic"),
        BETTER(1, 64000, "better"),
        ADVANCED(2, 128000, "advanced"),
        REINFORCED(3, 256000, "reinforced"),
        EXTRAODINARY(4, 1024000, "extraordinary"),
        NONE(5, 0, "none");

        private static TankTier[] META_LOOKUP;
        private final int meta;
        private final int capacity;
        private final String name;

        private TankTier(int meta, int capacity, String name) {
            this.meta = meta;
            this.capacity = capacity;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public boolean availiable() {
            return this.meta != 5;
        }

        public static TankTier byMeta(int meta) {
            if (meta >= 0 && meta < 6) {
                return META_LOOKUP[meta];
            }
            return NONE;
        }

        public static int getCapacity(int meta) {
            return TankTier.byMeta(meta).getCapacity();
        }

        static {
            META_LOOKUP = new TankTier[6];
            TankTier[] tankTierArray = TankTier.values();
            int n = tankTierArray.length;
            for (int i = 0; i < n; ++i) {
                TankTier tier;
                TankTier.META_LOOKUP[tier.meta] = tier = tankTierArray[i];
            }
        }
    }
}

