/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.items;

import hmysjiang.usefulstuffs.ConfigManager;
import hmysjiang.usefulstuffs.Reference;
import hmysjiang.usefulstuffs.UsefulStuffs;
import hmysjiang.usefulstuffs.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMilkBag
extends Item {
    public static ItemStack fermented;
    public static List<Potion> negativeEffects;
    private Random rnd;

    public static void setDefaultTag(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("FermentLevel", 0);
    }

    public static boolean isCompletelyFermented(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        if (stack.func_77952_i() == 8) {
            return false;
        }
        return stack.func_77978_p().func_74762_e("FermentLevel") >= 100;
    }

    public ItemMilkBag() {
        this.func_77655_b(Reference.ModItems.MILK_BAG.getUnlocalizedName());
        this.setRegistryName(Reference.ModItems.MILK_BAG.getRegistryName());
        this.func_77625_d(1);
        this.func_77656_e(8);
        this.setNoRepair();
        fermented = new ItemStack((Item)this);
        ItemMilkBag.setDefaultTag(fermented);
        fermented.func_77978_p().func_74768_a("FermentLevel", 100);
        this.rnd = new Random();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77942_o() && ItemMilkBag.isCompletelyFermented(stack)) {
            stack.func_77964_b(stack.func_77952_i() + 1);
            playerIn.func_191521_c(new ItemStack(ModItems.cheese, 3));
            if (stack.func_77952_i() == 8) {
                stack.func_77978_p().func_74768_a("FermentLevel", 0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (playerIn.func_70093_af() || stack.func_77952_i() == 8) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("FermentLevel")) {
            ItemMilkBag.setDefaultTag(stack);
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("FermentLevel") > 0) {
            return false;
        }
        if (playerIn.func_70093_af() && target.getClass().equals(EntityCow.class)) {
            if (playerIn.field_70170_p.field_72995_K) {
                playerIn.field_70170_p.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 1.0f, 1.0f);
            } else {
                stack.func_77964_b(stack.func_77952_i() - 1);
            }
            return true;
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K && !ItemMilkBag.isCompletelyFermented(stack)) {
            if (ConfigManager.fermentedMilkCauseNegativeEffect) {
                int fermentLevel = (int)((float)stack.func_77978_p().func_74762_e("FermentLevel") * 0.8f);
                if (this.rnd.nextInt(100) < fermentLevel) {
                    entityLiving.func_70690_d(new PotionEffect(negativeEffects.get(this.rnd.nextInt(5)), 600));
                } else {
                    entityLiving.curePotionEffects(new ItemStack(Items.field_151117_aB));
                }
            } else {
                entityLiving.curePotionEffects(new ItemStack(Items.field_151117_aB));
            }
        }
        stack.func_77964_b(stack.func_77952_i() + 1);
        if (stack.func_77952_i() == 8 && stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("FermentLevel", 0);
        }
        return stack;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xFFFFFF;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == UsefulStuffs.TAB) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            items.add((Object)new ItemStack((Item)this, 1, 8));
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() == 8) {
            return super.func_77658_a() + "_empty";
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("FermentLevel") > 0) {
            if (ItemMilkBag.isCompletelyFermented(stack)) {
                return super.func_77658_a() + "_fermented";
            }
            return super.func_77658_a() + "_fermented_par";
        }
        return super.func_77667_c(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77952_i() < 7) {
            tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)"usefulstuffs.milk_bag.tooltip_1", (Object[])new Object[]{8 - stack.func_77952_i()}));
        } else {
            tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)"usefulstuffs.milk_bag.tooltip_1_1", (Object[])new Object[]{8 - stack.func_77952_i()}));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("FermentLevel") > 0) {
            tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)"usefulstuffs.milk_bag.tooltip_2", (Object[])new Object[]{String.valueOf(stack.func_77978_p().func_74762_e("FermentLevel")) + "%"}));
        }
        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.milk_bag.tooltip_3", (Object[])new Object[0]));
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"usefulstuffs.milk_bag.tooltip_4", (Object[])new Object[0]));
    }

    static {
        negativeEffects = new ArrayList<Potion>();
        negativeEffects.add(MobEffects.field_76440_q);
        negativeEffects.add(MobEffects.field_76431_k);
        negativeEffects.add(MobEffects.field_76436_u);
        negativeEffects.add(MobEffects.field_76421_d);
        negativeEffects.add(MobEffects.field_76437_t);
    }
}

