/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.items;

import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import hmysjiang.usefulstuffs.ConfigManager;
import hmysjiang.usefulstuffs.Reference;
import hmysjiang.usefulstuffs.UsefulStuffs;
import hmysjiang.usefulstuffs.entity.EntityLightBulb;
import hmysjiang.usefulstuffs.init.ModBlocks;
import hmysjiang.usefulstuffs.init.ModItems;
import hmysjiang.usefulstuffs.items.ItemLightBattery;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class ItemLightShooter
extends Item {
    public static int cooldown;
    public static final int MAX_AMMO = 256;

    public ItemLightShooter() {
        this(Reference.ModItems.LIGHT_SHOOTER.getUnlocalizedName(), Reference.ModItems.LIGHT_SHOOTER.getRegistryName());
    }

    public ItemLightShooter(String unlocalized, String registry) {
        this.func_77655_b(unlocalized);
        this.setRegistryName(registry);
        this.field_77777_bU = 1;
        cooldown = ConfigManager.shooterCD;
        if (cooldown > 0) {
            this.func_77656_e(cooldown);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack shooter = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af() && handIn == EnumHand.MAIN_HAND) {
            if (!worldIn.field_72995_K) {
                playerIn.openGui((Object)UsefulStuffs.instance, 11, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)shooter);
        }
        if (shooter.func_77952_i() == 0) {
            worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187715_dR, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                this.launch(shooter, worldIn, playerIn);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    protected void launch(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        int ammo = ItemLightShooter.getAmmo(playerIn, itemStackIn);
        if (ammo != 0) {
            EntityLightBulb entity = new EntityLightBulb(worldIn, (EntityLivingBase)playerIn, ammo != -1);
            entity.setThrowableHeading(playerIn.func_70040_Z().field_72450_a, playerIn.func_70040_Z().field_72448_b, playerIn.func_70040_Z().field_72449_c, 2.0f, 0.0f);
            worldIn.func_72838_d((Entity)entity);
            itemStackIn.func_77964_b(cooldown);
            ItemLightShooter.decrAmmoCount(playerIn, itemStackIn, 1);
        }
    }

    public static int getAmmo(EntityPlayer player, ItemStack itemStackIn) {
        int charge;
        if (ConfigManager.shooterAcceptBattery && (charge = ItemLightShooter.calculateInventoryLight(player)) >= ConfigManager.shooterUseBattery) {
            return -1;
        }
        return ItemLightShooter.getAmmo(itemStackIn);
    }

    public static int getAmmo(ItemStack itemStackIn) {
        int ammo = 0;
        ItemStackHandler handler = ItemLightShooter.getItemHandler(itemStackIn, "Cont");
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || !stack.func_77969_a(new ItemStack(ModBlocks.light_bulb))) continue;
            ammo += stack.func_190916_E();
        }
        return ammo;
    }

    public static int calculateInventoryLight(EntityPlayer player) {
        int charge = 0;
        IBaublesItemHandler handler = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_77973_b() != ModItems.light_battery) continue;
            charge += ItemLightBattery.getChargedEnergy(handler.getStackInSlot(i));
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != ModItems.light_battery) continue;
            charge += ItemLightBattery.getChargedEnergy(stack);
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_77973_b() != ModItems.light_battery) continue;
            charge += ItemLightBattery.getChargedEnergy(stack);
        }
        return charge;
    }

    public static boolean tryDecreaseInventoryLight(EntityPlayer player) {
        if (ItemLightShooter.calculateInventoryLight(player) < ConfigManager.shooterUseBattery) {
            return false;
        }
        int charge = ConfigManager.shooterUseBattery;
        IBaublesItemHandler handler = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
        for (int i = 0; i < handler.getSlots() && charge > 0; ++i) {
            if (handler.getStackInSlot(i).func_77973_b() != ModItems.light_battery) continue;
            charge -= ItemLightBattery.drainEnergy(handler.getStackInSlot(i), charge, false);
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (charge <= 0) break;
            if (stack.func_77973_b() != ModItems.light_battery) continue;
            charge -= ItemLightBattery.drainEnergy(stack, charge, false);
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (charge <= 0) break;
            if (stack.func_77973_b() != ModItems.light_battery) continue;
            charge -= ItemLightBattery.drainEnergy(stack, charge, false);
        }
        return true;
    }

    protected static ItemStackHandler getItemHandler(ItemStack itemStackIn, String key) {
        ItemStackHandler handler = new ItemStackHandler(4);
        if (itemStackIn.func_77942_o() && itemStackIn.func_77978_p().func_74764_b("Cont")) {
            handler.deserializeNBT(itemStackIn.func_77978_p().func_74775_l("Cont"));
        } else {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("Cont", (NBTBase)handler.serializeNBT());
            itemStackIn.func_77982_d(compound);
        }
        return handler;
    }

    public static void decrAmmoCount(EntityPlayer player, ItemStack itemStackIn, int amount) {
        if (ConfigManager.shooterAcceptBattery && ItemLightShooter.tryDecreaseInventoryLight(player)) {
            return;
        }
        ItemStackHandler handler = ItemLightShooter.getItemHandler(itemStackIn, "Cont");
        for (int i = 0; i < handler.getSlots() && handler.extractItem(i, 1, false).func_190926_b(); ++i) {
        }
        itemStackIn.func_77978_p().func_74782_a("Cont", (NBTBase)handler.serializeNBT());
    }

    public static int incrAmmoCount(ItemStack itemStackIn, int amount) {
        ItemStack ret;
        ItemStackHandler handler = ItemLightShooter.getItemHandler(itemStackIn, "Cont");
        for (int i = 0; i < handler.getSlots() && amount > 0; amount += ret.func_190916_E(), ++i) {
            int per = amount > 64 ? 64 : amount;
            amount -= per;
            ret = handler.insertItem(i, new ItemStack(ModBlocks.light_bulb, per), false);
        }
        itemStackIn.func_77978_p().func_74782_a("Cont", (NBTBase)handler.serializeNBT());
        return amount;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        if (ItemLightShooter.getAmmo(stack) > 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = String.valueOf(ItemLightShooter.getAmmo(stack));
            objectArray[1] = String.valueOf(256);
            tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)"usefulstuffs.light_shooter.tooltip_1", (Object[])objectArray));
        } else {
            Object[] objectArray = new Object[2];
            objectArray[0] = 0;
            objectArray[1] = String.valueOf(256);
            tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)"usefulstuffs.light_shooter.tooltip_1", (Object[])objectArray));
        }
        if (ConfigManager.shooterAcceptBattery) {
            tooltip.add(I18n.func_135052_a((String)"usefulstuffs.light_shooter.tooltip_battery_true", (Object[])new Object[]{String.valueOf(ConfigManager.shooterUseBattery)}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"usefulstuffs.light_shooter.tooltip_battery_false", (Object[])new Object[0]));
        }
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"usefulstuffs.light_shooter.tooltip_2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"usefulstuffs.light_shooter.tooltip_3", (Object[])new Object[0]));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77951_h()) {
            stack.func_77964_b(stack.func_77952_i() - 1);
            if (!stack.func_77951_h() && entityIn instanceof EntityPlayer) {
                worldIn.func_184133_a((EntityPlayer)entityIn, entityIn.func_180425_c(), SoundEvents.field_187712_dQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

