/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.items;

import hmysjiang.usefulstuffs.ConfigManager;
import hmysjiang.usefulstuffs.Reference;
import hmysjiang.usefulstuffs.UsefulStuffs;
import hmysjiang.usefulstuffs.entity.EntityLightArrow;
import hmysjiang.usefulstuffs.utils.ILightChargable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemLightBow
extends ItemBow
implements ILightChargable {
    public ItemLightBow() {
        this.func_77655_b(Reference.ModItems.LIGHT_BOW.getUnlocalizedName());
        this.setRegistryName(Reference.ModItems.LIGHT_BOW.getRegistryName());
        this.func_77625_d(1);
        this.func_77656_e(400);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemLightBow ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.field_71075_bZ.field_75098_d || !stack.func_77951_h()) {
            playerIn.func_184598_c(handIn);
            ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)true);
            if (ret != null) {
                return ret;
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeleft) {
        if (entityLiving instanceof EntityPlayer) {
            int duration = this.func_77626_a(stack) - timeleft;
            int actualPullingTime = timeleft < 71980 ? 20 : 72000 - timeleft;
            ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)((EntityPlayer)entityLiving), (int)duration, (boolean)true);
            if (duration < 0) {
                return;
            }
            float vel = ItemBow.func_185059_b((int)duration);
            if ((double)vel >= 0.1) {
                int power;
                EntityLightArrow arrow = new EntityLightArrow(worldIn, entityLiving);
                arrow.func_184547_a((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, vel * 10.0f, 0.1f);
                arrow.func_70239_b(1.25);
                if (vel == 1.0f) {
                    arrow.func_70243_d(true);
                }
                if ((power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                    arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
                }
                stack.func_77964_b(actualPullingTime * 20);
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d((Entity)arrow);
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer) {
            this.charge(worldIn, stack, entityIn.func_180425_c());
        }
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xFFFA00;
    }

    public int func_77619_b() {
        return 3;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == UsefulStuffs.TAB) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    @SubscribeEvent
    public static void onFOVUpdate(FOVUpdateEvent event) {
        EntityPlayer player;
        if (ConfigManager.lightBowEnabled && (player = event.getEntity()) != null && !player.func_184607_cu().func_190926_b() && player.func_184607_cu().func_77973_b() instanceof ItemLightBow) {
            float fov = event.getFov();
            int duration = 72000 - player.func_184605_cv();
            if (duration > 40) {
                duration = 40;
            }
            float multiplier = (float)(1.0 - 0.3 * (double)duration / 40.0);
            event.setNewfov(fov * multiplier);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.light_bow.tooltip_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.light_bow.tooltip_2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)"usefulstuffs.light_bow.tooltip_charge", (Object[])new Object[]{String.valueOf(stack.func_77958_k() - stack.func_77952_i())}));
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"usefulstuffs.light_bow.tooltip_3", (Object[])new Object[0]));
    }
}

