/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import hmysjiang.usefulstuffs.Reference;
import hmysjiang.usefulstuffs.UsefulStuffs;
import hmysjiang.usefulstuffs.enchantment.EnchantmentMoonLight;
import hmysjiang.usefulstuffs.utils.ILightChargable;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLightBattery
extends Item
implements ILightChargable,
IBauble {
    public static int getChargedEnergy(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemLightBattery)) {
            return 0;
        }
        return stack.func_77958_k() - stack.func_77952_i();
    }

    public static int drainEnergy(ItemStack stack, int amount, boolean simulate) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemLightBattery)) {
            return 0;
        }
        int charge = ItemLightBattery.getChargedEnergy(stack);
        if (charge < amount) {
            if (!simulate) {
                stack.func_77964_b(stack.func_77958_k());
            }
            return charge;
        }
        if (!simulate) {
            stack.func_77964_b(stack.func_77952_i() + amount);
        }
        return amount;
    }

    public ItemLightBattery() {
        this.func_77655_b(Reference.ModItems.LIGHT_BATTERY.getUnlocalizedName());
        this.setRegistryName(Reference.ModItems.LIGHT_BATTERY.getRegistryName());
        this.func_77625_d(1);
        this.func_77656_e(32000);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.charge(worldIn, stack, entityIn.func_180425_c());
        if (entityIn instanceof EntityPlayer) {
            this.chargeInventory(stack, (EntityPlayer)entityIn, itemSlot);
        }
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        this.charge(player.field_70170_p, itemstack, player.func_180425_c());
        if (player instanceof EntityPlayer) {
            this.chargeInventory(itemstack, (EntityPlayer)player, -1);
        }
    }

    private void chargeInventory(ItemStack battery, EntityPlayer player, int itemSlot) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!(stack.func_77973_b() instanceof ILightChargable) || stack.func_77973_b() instanceof ItemLightBattery) continue;
            this.chargeItem(battery, stack);
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (!(stack.func_77973_b() instanceof ILightChargable) || stack.func_77973_b() instanceof ItemLightBattery) continue;
            this.chargeItem(battery, stack);
        }
    }

    private void chargeItem(ItemStack battery, ItemStack stack) {
        int charge = ItemLightBattery.getChargedEnergy(battery);
        if (charge > 0) {
            if (charge > 10) {
                charge = 10;
            }
            if (charge > stack.func_77952_i()) {
                charge = stack.func_77952_i();
            }
            battery.func_77964_b(battery.func_77952_i() + charge);
            stack.func_77964_b(stack.func_77952_i() - charge);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == UsefulStuffs.TAB) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xFFFA00;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    public int func_77619_b() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == EnchantmentMoonLight.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.light_battery.tooltip_1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)"usefulstuffs.light_battery.tooltip_charge", (Object[])new Object[]{String.valueOf(ItemLightBattery.getChargedEnergy(stack))}));
        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.light_battery.tooltip_2", (Object[])new Object[0]));
    }
}

