/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.container;

import hmysjiang.usefulstuffs.container.ContainerBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ContainerItem
extends ContainerBase {
    protected EntityPlayer player;
    protected ItemStack stack;
    protected int size;
    protected int blocked = -1;

    protected static ItemStackHandler getDeserializedHandler(ItemStack stack, int size) {
        ItemStackHandler handler = new ItemStackHandler(size);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Cont")) {
            handler.deserializeNBT(stack.func_77978_p().func_74775_l("Cont"));
        }
        return handler;
    }

    public ContainerItem(EntityPlayer player, IInventory inv, ItemStack stack, int size) {
        super(inv, ContainerItem.getDeserializedHandler(stack, size));
        this.player = player;
        this.stack = stack;
        this.size = size;
        if (inv instanceof InventoryPlayer) {
            this.blocked = size + 27 + ((InventoryPlayer)inv).field_70461_c;
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.saveContainer();
    }

    public void saveContainer() {
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        this.stack.func_77978_p().func_74782_a("Cont", (NBTBase)this.handler.serializeNBT());
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId < 0 || slotId > this.field_75151_b.size()) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (slotId == this.blocked) {
            return ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @SideOnly(value=Side.CLIENT)
    public String getStackDisplayName() {
        if (this.stack.func_82837_s()) {
            return this.stack.func_82833_r();
        }
        return I18n.func_135052_a((String)(this.stack.func_77977_a() + ".name"), (Object[])new Object[0]);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }
}

