/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.blocks.universaluser;

import hmysjiang.usefulstuffs.blocks.universaluser.BlockUniversalUser;
import hmysjiang.usefulstuffs.utils.TileEntityRotatable;
import hmysjiang.usefulstuffs.utils.fakeplayer.FakePlayerHandler;
import hmysjiang.usefulstuffs.utils.fakeplayer.USFakePlayer;
import hmysjiang.usefulstuffs.utils.helper.WorldHelper;
import java.lang.ref.WeakReference;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityUniversalUser
extends TileEntityRotatable
implements ITickable {
    private static Random rnd = new Random();
    private ItemStackHandler inventory = new ItemStackHandler(9);
    private FluidTank tank = new FluidTank(4000);
    private EnergyBank capacitor = new EnergyBank(200000);
    private EnergyBank innerCapacitor = new EnergyBank(50000, 10000);
    private ItemStack prevStack = ItemStack.field_190927_a;
    private int workTime = 0;
    public OperateSpeed operateSpeed = OperateSpeed.SLOW;
    public Activation activation = Activation.ACTIVATE_BLOCK;
    public Button button = Button.RIGHT;
    public Select select = Select.UPPER_LEFT;
    public Redstone redstone = Redstone.ACTIVE_ON_REDSTONE;
    private WeakReference<USFakePlayer> refPlayer;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.callUpdate();
            if (this.innerCapacitor.getEnergyStored() < this.innerCapacitor.getMaxEnergyStored()) {
                int charge = this.innerCapacitor.receiveEnergy(this.capacitor.extractEnergy(10000, true), true);
                this.innerCapacitor.receiveEnergy(this.capacitor.extractEnergy(charge, false), false);
                this.func_70296_d();
            }
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                    IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                    int charge = storage.receiveEnergy(this.innerCapacitor.extractEnergy(10000, true), true);
                    storage.receiveEnergy(this.innerCapacitor.extractEnergy(charge, false), false);
                    this.func_70296_d();
                }
                if (stack.func_77973_b() == Items.field_151133_ar) {
                    if (this.tank.getFluid() == null || this.tank.drain((int)1000, (boolean)false).amount != 1000) continue;
                    boolean flag = false;
                    ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)this.tank.getFluid());
                    stack.func_190918_g(1);
                    for (int j = 0; j < 9; ++j) {
                        if (!this.inventory.insertItem(j, bucket, false).func_190926_b()) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, bucket));
                    }
                    this.tank.drain(1000, true);
                    this.func_70296_d();
                    continue;
                }
                if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) continue;
                IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (this.tank.getFluid() == null || handler.fill(this.tank.getFluid(), false) <= 0) continue;
                FluidStack fluid = this.tank.drain(250, true);
                fluid.amount -= handler.fill(fluid.copy(), true);
                this.tank.fill(fluid, true);
                this.func_70296_d();
            }
            if (this.workTime == this.operateSpeed.cooldown) {
                if (this.redstone != Redstone.ALWAYS_ACTIVE && this.redstone == Redstone.ACTIVE_ON_REDSTONE ^ this.field_145850_b.func_175640_z(this.field_174879_c)) {
                    return;
                }
                if (this.capacitor.getEnergyStored() < this.operateSpeed.getEnergyCost()) {
                    return;
                }
                this.capacitor.extractEnergy(this.operateSpeed.getEnergyCost(), false);
                BlockUniversalUser cfr_ignored_0 = (BlockUniversalUser)this.field_145854_h;
                EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockUniversalUser.field_176387_N);
                if (this.refPlayer == null || this.refPlayer.get() == null) {
                    this.refPlayer = FakePlayerHandler.INSTANCE.getFakePlayer((WorldServer)this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, facing);
                }
                for (int i = 0; i < 9; ++i) {
                    ((USFakePlayer)((Object)this.refPlayer.get())).field_71071_by.func_70299_a(i, this.inventory.getStackInSlot(i).func_77946_l());
                }
                ((USFakePlayer)((Object)this.refPlayer.get())).field_71071_by.field_70461_c = this.select == Select.RANDOM ? this.getRandom() : 0;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing));
                ItemStack stack = ((USFakePlayer)((Object)this.refPlayer.get())).field_71071_by.func_70301_a(((USFakePlayer)((Object)this.refPlayer.get())).field_71071_by.field_70461_c);
                if (!stack.func_77969_a(this.prevStack)) {
                    if (!this.prevStack.func_190926_b()) {
                        ((USFakePlayer)((Object)this.refPlayer.get())).func_110140_aT().func_111148_a(this.prevStack.func_111283_C(EntityEquipmentSlot.MAINHAND));
                    }
                    if (!stack.func_190926_b()) {
                        ((USFakePlayer)((Object)this.refPlayer.get())).func_110140_aT().func_111147_b(stack.func_111283_C(EntityEquipmentSlot.MAINHAND));
                    }
                    this.prevStack = stack.func_77946_l();
                }
                try {
                    block1 : switch (this.activation) {
                        case ACTIVATE_BLOCK: {
                            if (this.button != Button.RIGHT) break;
                            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)((EntityPlayer)this.refPlayer.get()), (EnumHand)EnumHand.MAIN_HAND, (BlockPos)this.field_174879_c.func_177972_a(facing), (EnumFacing)facing.func_176734_d(), (Vec3d)WorldHelper.getHitVecFromAdjacent(facing));
                            if (!event.isCanceled() && event.getUseBlock() != Event.Result.DENY) {
                                state.func_177230_c().func_180639_a(this.field_145850_b, this.field_174879_c.func_177972_a(facing), state, (EntityPlayer)this.refPlayer.get(), EnumHand.MAIN_HAND, facing.func_176734_d(), 0.5f, 0.5f, 0.5f);
                            }
                            break;
                        }
                        case CLICK_BLOCK: {
                            PlayerInteractEvent.LeftClickBlock event = null;
                            switch (this.button) {
                                case LEFT: {
                                    event = ForgeHooks.onLeftClickBlock((EntityPlayer)((EntityPlayer)this.refPlayer.get()), (BlockPos)this.field_174879_c.func_177972_a(facing), (EnumFacing)facing.func_176734_d(), (Vec3d)WorldHelper.getHitVecFromAdjacent(facing));
                                    break;
                                }
                                case RIGHT: {
                                    event = ForgeHooks.onRightClickBlock((EntityPlayer)((EntityPlayer)this.refPlayer.get()), (EnumHand)EnumHand.MAIN_HAND, (BlockPos)this.field_174879_c.func_177972_a(facing), (EnumFacing)facing.func_176734_d(), (Vec3d)WorldHelper.getHitVecFromAdjacent(facing));
                                    break;
                                }
                            }
                            if (event == null || event.isCanceled()) break;
                            if (event instanceof PlayerInteractEvent.LeftClickBlock && ((PlayerInteractEvent.LeftClickBlock)event).getUseBlock() != Event.Result.DENY) {
                                state.func_177230_c().func_180649_a(this.field_145850_b, this.field_174879_c.func_177972_a(facing), (EntityPlayer)this.refPlayer.get());
                                break;
                            }
                            if (!(event instanceof PlayerInteractEvent.RightClickBlock)) break;
                            state.func_177230_c().func_180649_a(this.field_145850_b, this.field_174879_c.func_177972_a(facing), (EntityPlayer)this.refPlayer.get());
                            break;
                        }
                        case CLICK_ITEM: {
                            switch (this.button) {
                                case LEFT: {
                                    EntityLivingBase living = WorldHelper.rayTraceEntity(this.field_145850_b, this.field_174879_c, facing, 1.5);
                                    if (living == null || stack.func_77973_b().onLeftClickEntity(stack, (EntityPlayer)this.refPlayer.get(), (Entity)living) || living.field_70128_L) break block1;
                                    ((USFakePlayer)((Object)this.refPlayer.get())).func_71059_n((Entity)living);
                                    break block1;
                                }
                                case RIGHT: {
                                    ((USFakePlayer)((Object)this.refPlayer.get())).field_71134_c.func_187250_a((EntityPlayer)this.refPlayer.get(), this.field_145850_b, stack, EnumHand.MAIN_HAND);
                                    break block1;
                                }
                            }
                            break;
                        }
                        case ENTITY: {
                            EntityLivingBase living = WorldHelper.rayTraceEntity(this.field_145850_b, this.field_174879_c, facing, 1.5);
                            if (living == null) break;
                            switch (this.button) {
                                case LEFT: {
                                    if (living.field_70128_L) break block1;
                                    ((USFakePlayer)((Object)this.refPlayer.get())).func_71059_n((Entity)living);
                                    break block1;
                                }
                                case RIGHT: {
                                    stack.func_77973_b().func_111207_a(stack, (EntityPlayer)this.refPlayer.get(), living, EnumHand.MAIN_HAND);
                                    break block1;
                                }
                            }
                            break;
                        }
                        case USE_ITEM: {
                            if (this.button != Button.RIGHT) break;
                            stack.func_179546_a((EntityPlayer)this.refPlayer.get(), this.field_145850_b, this.field_174879_c.func_177972_a(facing), EnumHand.MAIN_HAND, facing.func_176734_d(), 0.5f, 0.5f, 0.5f);
                            break;
                        }
                    }
                }
                catch (Exception event) {
                    // empty catch block
                }
                for (int i = 0; i < 9; ++i) {
                    if (ItemStack.func_77989_b((ItemStack)this.inventory.getStackInSlot(i), (ItemStack)((USFakePlayer)((Object)this.refPlayer.get())).field_71071_by.func_70301_a(i)) && ItemStack.func_77970_a((ItemStack)this.inventory.getStackInSlot(i), (ItemStack)((USFakePlayer)((Object)this.refPlayer.get())).field_71071_by.func_70301_a(i))) continue;
                    this.inventory.setStackInSlot(i, ((USFakePlayer)((Object)this.refPlayer.get())).field_71071_by.func_70301_a(i).func_77946_l());
                }
                this.resetWorkTime();
                this.func_70296_d();
            } else {
                ++this.workTime;
            }
        }
    }

    protected void callUpdate() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
    }

    public void onChunkUnload() {
        if (this.refPlayer != null && this.refPlayer.get() != null) {
            this.refPlayer.clear();
        }
    }

    public void func_145843_s() {
        if (this.refPlayer != null && this.refPlayer.get() != null) {
            this.refPlayer.clear();
        }
        super.func_145843_s();
    }

    private int getRandom() {
        int ret;
        int flag = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            flag += 1 << i;
        }
        if (flag == 0) {
            return 0;
        }
        while ((flag & 1 << (ret = rnd.nextInt(9))) == 0) {
        }
        return ret;
    }

    public void resetWorkTime() {
        this.workTime = 0;
    }

    public EnergyBank getInnerCapacitor() {
        return this.innerCapacitor;
    }

    public EnergyBank getCapacitor() {
        return this.capacitor;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null) {
            BlockUniversalUser cfr_ignored_0 = (BlockUniversalUser)this.field_145854_h;
            if (facing == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockUniversalUser.field_176387_N)) {
                return null;
            }
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.capacitor);
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.readPartialNBT(compound);
        this.workTime = compound.func_74762_e("workTime");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("workTime", this.workTime);
        return super.func_189515_b(this.writePartialNBT(compound));
    }

    public void readPartialNBT(NBTTagCompound compound) {
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.capacitor.setEnergy(compound.func_74762_e("energy"));
        this.innerCapacitor.setEnergy(compound.func_74762_e("innerEnergy"));
        this.prevStack.deserializeNBT(compound.func_74775_l("prevStack"));
        this.operateSpeed = OperateSpeed.fromId(compound.func_74762_e("operateSpeed"));
        this.activation = Activation.fromId(compound.func_74762_e("activation"));
        this.button = Button.fromId(compound.func_74762_e("button"));
        this.select = Select.fromId(compound.func_74762_e("select"));
        this.redstone = Redstone.fromId(compound.func_74762_e("redstone"));
    }

    public NBTTagCompound writePartialNBT(NBTTagCompound compound) {
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("energy", this.capacitor.getEnergyStored());
        compound.func_74768_a("innerEnergy", this.innerCapacitor.getEnergyStored());
        compound.func_74782_a("prevStack", (NBTBase)this.prevStack.serializeNBT());
        compound.func_74768_a("operateSpeed", this.operateSpeed.getId());
        compound.func_74768_a("activation", this.activation.getId());
        compound.func_74768_a("button", this.button.getId());
        compound.func_74768_a("select", this.select.getId());
        compound.func_74768_a("redstone", this.redstone.getId());
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public static class EnergyBank
    extends EnergyStorage {
        public EnergyBank(int capacity) {
            super(capacity);
        }

        public EnergyBank(int capacity, int maxReceive) {
            super(capacity, maxReceive);
        }

        public EnergyBank(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        public EnergyBank(int capacity, int maxReceive, int maxExtract, int energy) {
            super(capacity, maxReceive, maxExtract, energy);
        }

        public void setEnergy(int amount) {
            this.energy = amount > this.getMaxEnergyStored() ? this.capacity : amount;
        }
    }

    public static enum Redstone {
        ACTIVE_ON_REDSTONE(0),
        ALWAYS_ACTIVE(1),
        ACTIVE_WITHOUT_REDSTONE(2);

        private static final ResourceLocation L_ACTIVE_ON_REDSTONE;
        private static final ResourceLocation L_ACTIVE_WITHOUT_REDSTONE;
        private static final ResourceLocation L_ALWAYS_ACTIVE;
        private static final Redstone[] LOOK_UP;
        private int id;

        private Redstone(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public Redstone next(boolean counter) {
            if (!counter) {
                return Redstone.fromId(this.getId() + 1);
            }
            return Redstone.fromId(this.getId() - 1 < 0 ? 2 : this.getId() - 1);
        }

        public ResourceLocation getImgLocation() {
            switch (this.id) {
                case 0: {
                    return L_ACTIVE_ON_REDSTONE;
                }
                case 1: {
                    return L_ALWAYS_ACTIVE;
                }
                case 2: {
                    return L_ACTIVE_WITHOUT_REDSTONE;
                }
            }
            return L_ACTIVE_ON_REDSTONE;
        }

        public String toString() {
            switch (this) {
                case ACTIVE_ON_REDSTONE: {
                    return "Active on redstone";
                }
                case ACTIVE_WITHOUT_REDSTONE: {
                    return "Active without redstone";
                }
                case ALWAYS_ACTIVE: {
                    return "Always active";
                }
            }
            return "";
        }

        public static Redstone fromId(int id) {
            return LOOK_UP[id];
        }

        static {
            L_ACTIVE_ON_REDSTONE = new ResourceLocation("blocks/redstone_torch_on");
            L_ACTIVE_WITHOUT_REDSTONE = new ResourceLocation("blocks/redstone_torch_off");
            L_ALWAYS_ACTIVE = new ResourceLocation("items/redstone_dust");
            LOOK_UP = new Redstone[4];
            Redstone[] redstoneArray = Redstone.values();
            int n = redstoneArray.length;
            for (int i = 0; i < n; ++i) {
                Redstone item;
                Redstone.LOOK_UP[item.getId()] = item = redstoneArray[i];
            }
            Redstone.LOOK_UP[3] = Redstone.fromId(0);
        }
    }

    public static enum Select {
        UPPER_LEFT(0),
        RANDOM(1);

        private static final Select[] LOOK_UP;
        private int id;

        private Select(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public Select next(boolean counter) {
            if (!counter) {
                return Select.fromId(this.getId() + 1);
            }
            return Select.fromId(this.getId() - 1 < 0 ? 1 : this.getId() - 1);
        }

        public String toString() {
            switch (this) {
                case RANDOM: {
                    return "Random Slot";
                }
                case UPPER_LEFT: {
                    return "Upper Left";
                }
            }
            return "";
        }

        public static Select fromId(int id) {
            return LOOK_UP[id];
        }

        static {
            LOOK_UP = new Select[3];
            Select[] selectArray = Select.values();
            int n = selectArray.length;
            for (int i = 0; i < n; ++i) {
                Select item;
                Select.LOOK_UP[item.getId()] = item = selectArray[i];
            }
            Select.LOOK_UP[2] = Select.fromId(0);
        }
    }

    public static enum Button {
        RIGHT(0),
        LEFT(1);

        private static final Button[] LOOK_UP;
        private int id;

        private Button(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public boolean isSneakMode() {
            return this.id > 1;
        }

        public Button next(boolean counter) {
            if (!counter) {
                return Button.fromId(this.getId() + 1);
            }
            return Button.fromId(this.getId() - 1 < 0 ? 1 : this.getId() - 1);
        }

        public String toString() {
            switch (this) {
                case LEFT: {
                    return "Left";
                }
                case RIGHT: {
                    return "Right";
                }
            }
            return "";
        }

        public static Button fromId(int id) {
            return LOOK_UP[id];
        }

        static {
            LOOK_UP = new Button[3];
            Button[] buttonArray = Button.values();
            int n = buttonArray.length;
            for (int i = 0; i < n; ++i) {
                Button item;
                Button.LOOK_UP[item.getId()] = item = buttonArray[i];
            }
            Button.LOOK_UP[2] = Button.fromId(0);
        }
    }

    public static enum Activation {
        ACTIVATE_BLOCK(0),
        CLICK_BLOCK(1),
        USE_ITEM(2),
        CLICK_ITEM(3),
        ENTITY(4);

        private static final Activation[] LOOK_UP;
        private int id;

        private Activation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public Activation next(boolean counter) {
            if (!counter) {
                return Activation.fromId(this.getId() + 1);
            }
            return Activation.fromId(this.getId() - 1 < 0 ? 4 : this.getId() - 1);
        }

        public String toString() {
            switch (this) {
                case ACTIVATE_BLOCK: {
                    return "Activate Block";
                }
                case CLICK_BLOCK: {
                    return "Click Block";
                }
                case CLICK_ITEM: {
                    return "Item Click";
                }
                case ENTITY: {
                    return "Entity";
                }
                case USE_ITEM: {
                    return "Use On Block";
                }
            }
            return "";
        }

        public static Activation fromId(int id) {
            return LOOK_UP[id];
        }

        static {
            LOOK_UP = new Activation[6];
            Activation[] activationArray = Activation.values();
            int n = activationArray.length;
            for (int i = 0; i < n; ++i) {
                Activation item;
                Activation.LOOK_UP[item.getId()] = item = activationArray[i];
            }
            Activation.LOOK_UP[5] = Activation.fromId(0);
        }
    }

    public static enum OperateSpeed {
        SLOW(0, 25, 200),
        FAST(1, 10, 275),
        FASTER(2, 5, 325),
        FASTEST(3, 1, 400);

        private static final OperateSpeed[] LOOK_UP;
        private int id;
        private int cooldown;
        private int energyCost;

        private OperateSpeed(int id, int cooldown, int energyCost) {
            this.id = id;
            this.cooldown = cooldown;
            this.energyCost = energyCost;
        }

        public int getId() {
            return this.id;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public int getEnergyCost() {
            return this.energyCost;
        }

        public OperateSpeed next(boolean counter) {
            if (!counter) {
                return OperateSpeed.fromId(this.getId() + 1);
            }
            return OperateSpeed.fromId(this.getId() - 1 < 0 ? 3 : this.getId() - 1);
        }

        public String toString() {
            switch (this) {
                case FAST: {
                    return "Fast";
                }
                case FASTER: {
                    return "Faster";
                }
                case FASTEST: {
                    return "Fastest";
                }
                case SLOW: {
                    return "Slow";
                }
            }
            return "";
        }

        public static OperateSpeed fromId(int id) {
            return LOOK_UP[id];
        }

        static {
            LOOK_UP = new OperateSpeed[5];
            OperateSpeed[] operateSpeedArray = OperateSpeed.values();
            int n = operateSpeedArray.length;
            for (int i = 0; i < n; ++i) {
                OperateSpeed item;
                OperateSpeed.LOOK_UP[item.getId()] = item = operateSpeedArray[i];
            }
            OperateSpeed.LOOK_UP[4] = OperateSpeed.fromId(0);
        }
    }
}

