/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.blocks.playerdetector;

import hmysjiang.usefulstuffs.ConfigManager;
import hmysjiang.usefulstuffs.Reference;
import hmysjiang.usefulstuffs.blocks.playerdetector.TileEntityPlayerDetector;
import hmysjiang.usefulstuffs.init.ModItems;
import hmysjiang.usefulstuffs.utils.helper.WorldHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlayerDetector
extends BlockHorizontal
implements ITileEntityProvider {
    public static int range;
    public static final PropertyBool POWERED;
    public static final PropertyBool UP;

    public static AxisAlignedBB getBoundingBoxFromFacing(EnumFacing facing, boolean up) {
        switch (facing) {
            case NORTH: {
                if (up) {
                    return new AxisAlignedBB(0.0625, 0.875, 0.0, 0.9375, 1.0, 0.125);
                }
                return new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.125, 0.125);
            }
            case SOUTH: {
                if (up) {
                    return new AxisAlignedBB(0.0625, 0.875, 0.875, 0.9375, 1.0, 1.0);
                }
                return new AxisAlignedBB(0.0625, 0.0, 0.875, 0.9375, 0.125, 1.0);
            }
            case EAST: {
                if (up) {
                    return new AxisAlignedBB(0.875, 0.875, 0.0625, 1.0, 1.0, 0.9375);
                }
                return new AxisAlignedBB(0.875, 0.0, 0.0625, 1.0, 0.125, 0.9375);
            }
            case WEST: {
                if (up) {
                    return new AxisAlignedBB(0.0, 0.875, 0.0625, 0.125, 1.0, 0.9375);
                }
                return new AxisAlignedBB(0.0, 0.0, 0.0625, 0.125, 0.125, 0.9375);
            }
        }
        return new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.125, 0.125);
    }

    public BlockPlayerDetector(boolean enabled) {
        super(Material.field_151576_e);
        this.func_149663_c(Reference.ModBlocks.PLAYER_DETECTOR.getUnlocalizedName());
        this.setRegistryName(Reference.ModBlocks.PLAYER_DETECTOR.getRegistryName());
        if (enabled) {
            ModItems.itemblocks.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        }
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)));
        range = ConfigManager.playerDetectorRange;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == state.func_177229_b((IProperty)field_185512_D) || side == ((Boolean)state.func_177229_b((IProperty)UP) != false ? EnumFacing.UP : EnumFacing.DOWN);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 0;
        }
        return side == ((EnumFacing)blockState.func_177229_b((IProperty)field_185512_D)).func_176734_d() || side == ((Boolean)blockState.func_177229_b((IProperty)UP) != false ? EnumFacing.UP : EnumFacing.DOWN) ? 15 : 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing == EnumFacing.DOWN) {
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(true));
        }
        if (facing == EnumFacing.UP) {
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false));
        }
        if ((double)hitY < 0.5) {
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(true));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, POWERED, UP});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta % 8 >= 4)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(meta >= 8));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 4 : 0) + ((Boolean)state.func_177229_b((IProperty)UP) != false ? 8 : 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BlockPlayerDetector.getBoundingBoxFromFacing((EnumFacing)state.func_177229_b((IProperty)field_185512_D), (Boolean)state.func_177229_b((IProperty)UP));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, worldIn, pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPlayerDetector();
    }

    public void updateState(World world, BlockPos pos, boolean allowOff) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            AxisAlignedBB bb = new AxisAlignedBB(pos).func_186662_g((double)range);
            EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_185512_D);
            boolean powered = false;
            if (ConfigManager.onlyDetectOneSide) {
                for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, bb)) {
                    if (!WorldHelper.isRelationCorrect(pos, player.func_180425_c(), facing.func_176734_d(), true)) continue;
                    powered = true;
                    break;
                }
            } else {
                powered = world.func_72872_a(EntityPlayer.class, bb).size() > 0;
            }
            boolean flag = powered ^ (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)POWERED);
            if (powered) {
                world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            } else if (allowOff) {
                world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
            if (flag) {
                this.notifyNeighbors(world, pos, facing);
                world.func_175684_a(pos, (Block)this, 20);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)field_185512_D));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    private void notifyNeighbors(World world, BlockPos pos, EnumFacing facing) {
        world.func_175685_c(pos, (Block)this, false);
        world.func_175685_c(pos.func_177972_a(facing), (Block)this, false);
        world.func_175685_c(pos.func_177972_a(EnumFacing.DOWN), (Block)this, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"usefulstuffs.player_detector.tooltip", (Object[])new Object[]{range * 2 + 1, range * 2 + 1, range * 2 + 1}));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.updateState(worldIn, pos, true);
        }
    }

    static {
        POWERED = PropertyBool.func_177716_a((String)"powered");
        UP = PropertyBool.func_177716_a((String)"upside");
    }
}

