/*
 * Decompiled with CFR 0.152.
 */
package hmysjiang.usefulstuffs.blocks.campfire;

import hmysjiang.usefulstuffs.ConfigManager;
import hmysjiang.usefulstuffs.Reference;
import hmysjiang.usefulstuffs.UsefulStuffs;
import hmysjiang.usefulstuffs.blocks.BlockMaterials;
import hmysjiang.usefulstuffs.blocks.campfire.TileEntityCampfire;
import hmysjiang.usefulstuffs.init.ModBlocks;
import hmysjiang.usefulstuffs.init.ModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class BlockCampfire
extends Block
implements ITileEntityProvider {
    public static boolean needFuel;
    private static final AxisAlignedBB BOUNDING_BOX;
    private Random rnd = new Random();

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player;
        if (ConfigManager.enableCampfireCraft && (player = event.getEntityPlayer()).func_70093_af() && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_185136_b(new ItemStack(Items.field_151033_d)) && (player.field_70170_p.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150364_r || player.field_70170_p.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150363_s)) {
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack stack = player.func_184614_ca();
                if (stack.func_77952_i() >= stack.func_77958_k()) {
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        if (player.field_71071_by.func_70301_a(i) != stack) continue;
                        player.field_71071_by.func_70304_b(i);
                    }
                } else {
                    stack.func_77964_b(stack.func_77952_i() + 1);
                }
            }
            player.field_70170_p.func_175656_a(event.getPos(), ModBlocks.campfire.func_176223_P());
            event.setCanceled(true);
        }
    }

    public BlockCampfire(boolean enabled) {
        super(BlockMaterials.CAMPFIRE);
        this.setRegistryName(Reference.ModBlocks.CAMPFIRE.getRegistryName());
        this.func_149663_c(Reference.ModBlocks.CAMPFIRE.getUnlocalizedName());
        if (enabled) {
            ModItems.itemblocks.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        }
        this.func_149715_a(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.5f);
        needFuel = ConfigManager.campfireNeedsFuel;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (needFuel) {
                playerIn.openGui((Object)UsefulStuffs.instance, 12, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Radius: " + ((TileEntityCampfire)worldIn.func_175625_s(pos)).getBuffRadius()));
            }
        }
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175625_s(pos) != null) {
            IItemHandler handler = needFuel ? (IItemHandler)((TileEntityCampfire)worldIn.func_175625_s(pos)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) : (IItemHandler)((TileEntityCampfire)worldIn.func_175625_s(pos)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, handler.getStackInSlot(i)));
            }
        }
        worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(Items.field_151055_y, this.rnd.nextInt(2) + 2)));
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCampfire();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, worldIn, tooltip, advanced);
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"usefulstuffs.campfire.tooltip_1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"usefulstuffs.campfire.tooltip_2", (Object[])new Object[0]));
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (worldIn.func_175623_d(pos.func_177977_b())) {
            worldIn.func_175698_g(pos);
        }
    }

    static {
        BOUNDING_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.25, 0.9375);
    }
}

