/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.tb.common.block;

import com.rumaruka.tb.common.block.BlockTBPlant;
import com.rumaruka.tb.utils.TBConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockSweed
extends BlockTBPlant {
    public BlockSweed(int stages, int delay, boolean isCrop) {
        super(stages, delay, isCrop);
        this.func_149675_a(true);
    }

    protected boolean canPlaceBlockOn(Block b) {
        return b != null && (b == Blocks.field_150349_c || b == Blocks.field_150346_d || b instanceof BlockGrass || b instanceof BlockDirt);
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        Block b = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return this.canPlaceBlockOn(b);
    }

    public int func_149738_a(World worldIn) {
        return 1200 + worldIn.field_73012_v.nextInt(1200);
    }

    @Override
    public int getGrowthStages() {
        return 3;
    }

    @Override
    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int groM = (Integer)state.func_177229_b((IProperty)this.AGE);
        if (groM < this.getGrowthStages()) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)this.AGE, (Comparable)Integer.valueOf(groM + 1)));
        }
    }

    @Override
    public void func_180650_b(World w, BlockPos pos, IBlockState state, Random rnd) {
        EnumFacing dir;
        BlockPos posN;
        super.func_180650_b(w, pos, state, rnd);
        if ((Integer)state.func_177229_b((IProperty)this.AGE) < 3 && !w.field_72995_K && this.canPlaceBlockOn(w.func_180495_p((posN = pos.func_177972_a(dir = EnumFacing.func_82600_a((int)(2 + w.field_73012_v.nextInt(4))))).func_177977_b()).func_177230_c()) && w.func_175623_d(posN)) {
            w.func_175656_a(posN, this.func_176203_a(Math.min(3, this.func_176201_c(state) + 1)));
        }
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess w, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (w instanceof World) {
            World world = (World)World.class.cast(w);
            int metadata = (Integer)state.func_177229_b((IProperty)this.AGE);
            if (metadata >= this.growthStages - 1) {
                int i;
                for (i = 0; i < 1 + fortune; ++i) {
                    if (world.field_73012_v.nextInt(this.growthStages) > metadata || this.dropSeed == null) continue;
                    ret.add(this.dropSeed.func_77946_l());
                }
                for (i = 0; i < TBConfig.firstDropItemInSeeeds + fortune; ++i) {
                    if (!world.field_73012_v.nextBoolean()) continue;
                    ret.add(new ItemStack(Items.field_151102_aT));
                }
                for (i = 0; i < TBConfig.extraDropItemInSeeeds + fortune; ++i) {
                    if (!world.field_73012_v.nextBoolean()) continue;
                    ret.add(new ItemStack(Items.field_151120_aE));
                }
            }
        }
        return ret;
    }
}

