/*
 * Decompiled with CFR 0.152.
 */
package quaternary.simpletrophies.client;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import quaternary.simpletrophies.client.tesr.RenderItemStackSimpleTrophy;
import quaternary.simpletrophies.client.tesr.RenderTileSimpleTrophy;
import quaternary.simpletrophies.common.block.SimpleTrophiesBlocks;
import quaternary.simpletrophies.common.config.SimpleTrophiesConfig;
import quaternary.simpletrophies.common.etc.TrophyHelpers;
import quaternary.simpletrophies.common.item.SimpleTrophiesItems;
import quaternary.simpletrophies.common.tile.TileSimpleTrophy;

@Mod.EventBusSubscriber(modid="simple_trophies", value={Side.CLIENT})
public class ClientGameEvents {
    private static long ticksInGame = 0L;
    private static boolean paused = false;
    private static float lastNonPausedPartialTicks = 0.0f;

    @SubscribeEvent
    public static void models(ModelRegistryEvent e) {
        if (SimpleTrophiesConfig.NO_TEISR) {
            if (!SimpleTrophiesConfig.SKIP_ITEM_BASES) {
                ModelLoader.setCustomMeshDefinition((Item)SimpleTrophiesItems.TROPHY, stack -> RenderItemStackSimpleTrophy.baseLocations.get((Object)TrophyHelpers.getDisplayedVariant(stack)));
                ModelLoader.registerItemVariants((Item)SimpleTrophiesItems.TROPHY, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("simple_trophies", "trophy")});
            }
        } else {
            ClientGameEvents.setSimpleItemModel((Item)SimpleTrophiesItems.TROPHY);
            SimpleTrophiesItems.TROPHY.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RenderItemStackSimpleTrophy());
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(resourceManager -> RenderItemStackSimpleTrophy.dumpCache());
        }
        if (!SimpleTrophiesConfig.NO_TESR) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileSimpleTrophy.class, (TileEntitySpecialRenderer)new RenderTileSimpleTrophy());
        }
    }

    private static void setSimpleItemModel(Item e) {
        ModelLoader.setCustomModelResourceLocation((Item)e, (int)0, (ModelResourceLocation)new ModelResourceLocation(e.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public static void blockColors(ColorHandlerEvent.Block e) {
        BlockColors bc = e.getBlockColors();
        bc.func_186722_a((state, world, pos, tintIndex) -> {
            if (world == null || pos == null || tintIndex != 0) {
                return 0xFFFFFF;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileSimpleTrophy) {
                TileSimpleTrophy trophy = (TileSimpleTrophy)tile;
                return TrophyHelpers.getCombinedColor(trophy);
            }
            return 0xFFFFFF;
        }, new Block[]{SimpleTrophiesBlocks.TROPHY});
    }

    @SubscribeEvent
    public static void itemColors(ColorHandlerEvent.Item e) {
        ItemColors ic = e.getItemColors();
        ic.func_186730_a((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            return TrophyHelpers.getCombinedColor(stack);
        }, new Item[]{SimpleTrophiesItems.TROPHY});
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiScreen ui = mc.field_71462_r;
            if (mc.func_71356_B() && ui != null && ui.func_73868_f() && mc.func_71401_C() != null && !mc.func_71401_C().func_71344_c()) {
                paused = true;
            } else {
                ++ticksInGame;
                paused = false;
            }
        }
    }

    public static long getTicksInGame() {
        return ticksInGame;
    }

    public static float getPauseAdjustedPartialTicks() {
        if (paused) {
            return lastNonPausedPartialTicks;
        }
        lastNonPausedPartialTicks = Minecraft.func_71410_x().func_184121_ak();
        return lastNonPausedPartialTicks;
    }

    public static float getPauseAdjustedTicksAndPartialTicks() {
        return (float)ClientGameEvents.getTicksInGame() + ClientGameEvents.getPauseAdjustedPartialTicks();
    }
}

