/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@RitualRegister(value="eternal_soul")
public class RitualEternalSoul
extends Ritual {
    private IBloodAltar altar = null;

    public RitualEternalSoul() {
        super("ritualEternalSoul", 2, 2000000, "ritual.bloodmagic.eternalSoulRitual");
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        UUID owner = masterRitualStone.getOwner();
        int currentEssence = NetworkHelper.getSoulNetwork(owner).getCurrentEssence();
        World world = masterRitualStone.getWorldObj();
        BlockPos pos = masterRitualStone.getBlockPos();
        if (this.altar == null) {
            for (int i = -5; i <= 5; ++i) {
                for (int j = -5; j <= 5; ++j) {
                    for (int k = -10; k <= 10; ++k) {
                        if (!(world.func_175625_s(new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k)) instanceof IBloodAltar)) continue;
                        this.altar = (IBloodAltar)world.func_175625_s(new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k));
                    }
                }
            }
        }
        if (!(this.altar instanceof IFluidHandler)) {
            return;
        }
        int horizontalRange = 15;
        int verticalRange = 20;
        List list = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)pos.func_177958_n() - 0.5f), (double)((float)pos.func_177956_o() - 0.5f), (double)((float)pos.func_177952_p() - 0.5f), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)).func_72321_a((double)horizontalRange, (double)verticalRange, (double)horizontalRange));
        EntityPlayer entityOwner = null;
        for (EntityPlayer player : list) {
            if (PlayerHelper.getUUIDFromPlayer(player) != owner) continue;
            entityOwner = player;
        }
        int fillAmount = Math.min(currentEssence / 2, ((IFluidHandler)this.altar).fill(new FluidStack(BlockLifeEssence.getLifeEssence(), 10000), false));
        ((IFluidHandler)this.altar).fill(new FluidStack(BlockLifeEssence.getLifeEssence(), fillAmount), true);
        if (entityOwner != null && entityOwner.func_110143_aJ() > 2.0f && fillAmount != 0) {
            entityOwner.func_70606_j(2.0f);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(fillAmount * 2));
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        int i;
        this.addCornerRunes(components, 0, 1, EnumRuneType.FIRE);
        for (i = 0; i < 4; ++i) {
            this.addCornerRunes(components, 2, i, EnumRuneType.AIR);
        }
        this.addCornerRunes(components, 4, 1, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 4, 1, EnumRuneType.EARTH);
        for (i = 0; i < 2; ++i) {
            this.addCornerRunes(components, 4, i + 2, EnumRuneType.WATER);
        }
        this.addCornerRunes(components, 4, 4, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 6, 5, 0, EnumRuneType.FIRE);
        for (i = 0; i < 2; ++i) {
            this.addCornerRunes(components, 6, i, EnumRuneType.FIRE);
        }
        for (i = 0; i < 3; ++i) {
            this.addCornerRunes(components, 6, i + 2, EnumRuneType.BLANK);
        }
        this.addCornerRunes(components, 6, 5, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualEternalSoul();
    }
}

