/*
 * Decompiled with CFR 0.152.
 */
package spawntabletweaker;

import crafttweaker.CraftTweakerAPI;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Level;

public class SpawnTableTweakerMC {
    private static Map<Class<? extends Entity>, EntityEntry> entityMap;
    private static final ResourceLocation ENTITY_CLASS_TO_ENTRY;
    private static Field BiomeTags;

    public static void preInit() {
        try {
            BiomeTags = BiomeDictionary.Type.class.getDeclaredField("byName");
            BiomeTags.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        entityMap = (Map)GameRegistry.findRegistry(EntityEntry.class).getSlaveMap(ENTITY_CLASS_TO_ENTRY, Map.class);
    }

    public static void removeSpawn(String registryName, String creaturetype, String ... names) {
        Biome[] biomes = SpawnTableTweakerMC.getBiomeList(names);
        if (biomes != null) {
            SpawnTableTweakerMC.removeSpawn(registryName, creaturetype, biomes);
        }
    }

    public static void removeSpawn(String registryName, String creaturetype, Biome[] biomes) {
        Class entClass = null;
        for (EntityEntry e : entityMap.values()) {
            if (!registryName.equals(e.getRegistryName().toString())) continue;
            if (!EntityLiving.class.isAssignableFrom(e.getEntityClass())) break;
            entClass = e.getEntityClass();
            break;
        }
        if (entClass != null) {
            EnumCreatureType type = SpawnTableTweakerMC.getEnumCreatureType(creaturetype);
            if (type != null) {
                if (biomes != null) {
                    EntityRegistry.removeSpawn(entClass, (EnumCreatureType)type, (Biome[])biomes);
                    SpawnTableTweakerMC.log(Level.INFO, "Removing SpawnEntries for: " + entClass.getCanonicalName());
                }
            } else {
                SpawnTableTweakerMC.log(Level.ERROR, "Invalid Enum Constant: " + creaturetype);
            }
        } else {
            SpawnTableTweakerMC.log(Level.ERROR, "Invalid Entity Registration: " + registryName);
        }
    }

    public static void removeSpawnAllBiomes(String registryName, String creaturetype) {
        SpawnTableTweakerMC.removeSpawn(registryName, creaturetype, SpawnTableTweakerMC.getAllBiomes());
    }

    public static void addSpawn(String registryName, int weight, int min, int max, String creaturetype, String ... names) {
        Biome[] biomes = SpawnTableTweakerMC.getBiomeList(names);
        if (biomes != null) {
            SpawnTableTweakerMC.addSpawn(registryName, weight, min, max, creaturetype, biomes);
        }
    }

    public static void addSpawnToTags(String registryName, int weight, int min, int max, String creaturetype, String ... tags) {
        Biome[] biomes;
        BiomeDictionary.Type[] t = SpawnTableTweakerMC.getTags(tags);
        if (t != null && (biomes = SpawnTableTweakerMC.getBiomesWithTags(t)) != null) {
            SpawnTableTweakerMC.addSpawn(registryName, weight, min, max, creaturetype, biomes);
        }
    }

    public static void addSpawnToTagsBlacklist(String registryName, int weight, int min, int max, String creaturetype, String ... tags) {
        Biome[] biomes;
        BiomeDictionary.Type[] t = SpawnTableTweakerMC.getTags(tags);
        if (t != null && (biomes = SpawnTableTweakerMC.getBiomesWithoutTags(t)) != null) {
            SpawnTableTweakerMC.addSpawn(registryName, weight, min, max, creaturetype, biomes);
        }
    }

    public static void addSpawn(String registryName, int weight, int min, int max, String creaturetype, Biome[] biomes) {
        Class entClass = null;
        for (EntityEntry e : entityMap.values()) {
            if (!registryName.equals(e.getRegistryName().toString())) continue;
            if (!EntityLiving.class.isAssignableFrom(e.getEntityClass())) break;
            entClass = e.getEntityClass();
            break;
        }
        if (entClass != null) {
            EnumCreatureType type = SpawnTableTweakerMC.getEnumCreatureType(creaturetype);
            if (type != null) {
                if (biomes != null) {
                    EntityRegistry.addSpawn(entClass, (int)weight, (int)min, (int)max, (EnumCreatureType)type, (Biome[])biomes);
                    SpawnTableTweakerMC.log(Level.INFO, "Successfully added SpawnEntry for: " + entClass.getCanonicalName());
                }
            } else {
                SpawnTableTweakerMC.log(Level.ERROR, "Invalid Enum Constant: " + creaturetype);
            }
        } else {
            SpawnTableTweakerMC.log(Level.ERROR, "Invalid Entity Registration: " + registryName);
        }
    }

    private static EnumCreatureType getEnumCreatureType(String type) {
        try {
            EnumCreatureType e = EnumCreatureType.valueOf((String)type);
            return e;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private static Biome[] getBiomeList(String ... names) {
        Biome[] biomes = new Biome[names.length];
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i] = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(names[i]));
            if (biomes[i] != null) continue;
            SpawnTableTweakerMC.log(Level.ERROR, "Invalid Biome Registration: " + names[i]);
            return null;
        }
        return biomes;
    }

    private static Biome[] getAllBiomes() {
        Set keys = Biome.field_185377_q.func_148742_b();
        Set entries = ForgeRegistries.BIOMES.getEntries();
        Biome[] biomes = new Biome[entries.size()];
        int i = 0;
        for (Map.Entry e : entries) {
            biomes[i++] = (Biome)e.getValue();
        }
        return biomes;
    }

    public static BiomeDictionary.Type[] getTags(String ... names) {
        BiomeDictionary.Type[] types = new BiomeDictionary.Type[names.length];
        Map byName = null;
        try {
            byName = (Map)BiomeTags.get(BiomeDictionary.Type.class);
            for (int i = 0; i < names.length; ++i) {
                types[i] = (BiomeDictionary.Type)byName.get(names[i]);
                if (types[i] != null) continue;
                SpawnTableTweakerMC.log(Level.ERROR, "Invalid BiomeDictionary Tag: " + names[i]);
                return null;
            }
            return types;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Biome[] getBiomesWithTags(BiomeDictionary.Type[] tags) {
        LinkedList biomes = new LinkedList();
        ForgeRegistries.BIOMES.forEach(b -> {
            if (SpawnTableTweakerMC.hasAnyOfTags(b, tags)) {
                biomes.add(b);
            }
        });
        return biomes.toArray(new Biome[biomes.size()]);
    }

    public static Biome[] getBiomesWithoutTags(BiomeDictionary.Type[] tags) {
        LinkedList biomes = new LinkedList();
        ForgeRegistries.BIOMES.forEach(b -> {
            if (!SpawnTableTweakerMC.hasAnyOfTags(b, tags)) {
                biomes.add(b);
            }
        });
        return biomes.toArray(new Biome[biomes.size()]);
    }

    protected static boolean hasAnyOfTags(Biome biome, BiomeDictionary.Type[] tags) {
        for (BiomeDictionary.Type tag : tags) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)tag)) continue;
            return true;
        }
        return false;
    }

    protected static void log(Level l, String message) {
        if (l == Level.ERROR) {
            CraftTweakerAPI.logError((String)message);
        } else if (l == Level.WARN) {
            CraftTweakerAPI.logWarning((String)message);
        } else if (l == Level.INFO) {
            CraftTweakerAPI.logInfo((String)message);
        } else {
            CraftTweakerAPI.logDefault((String)message);
        }
    }

    static {
        ENTITY_CLASS_TO_ENTRY = new ResourceLocation("forge:entity_class_to_entry");
        BiomeTags = null;
    }
}

