/*
 * Decompiled with CFR 0.152.
 */
package spawntabletweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import spawntabletweaker.SpawnTableTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.spawntabletweaker")
public class SpawnTableTweakerCT {
    @ZenMethod
    public static void addSpawn(String registryName, int weight, int min, int max, String creatureType, String[] names) {
        CraftTweakerAPI.apply((IAction)new addSpawnAction(registryName, weight, min, max, creatureType, names, MODE.NAMES));
    }

    @ZenMethod
    public static void addSpawnTagsWhitelist(String registryName, int weight, int min, int max, String creatureType, String[] names) {
        CraftTweakerAPI.apply((IAction)new addSpawnAction(registryName, weight, min, max, creatureType, names, MODE.TAG_WHITELIST));
    }

    @ZenMethod
    public static void addSpawnTagsBlacklist(String registryName, int weight, int min, int max, String creatureType, String[] names) {
        CraftTweakerAPI.apply((IAction)new addSpawnAction(registryName, weight, min, max, creatureType, names, MODE.TAG_BLACKLIST));
    }

    @ZenMethod
    public static void removeSpawn(String registryName, String creatureType, String[] names) {
        CraftTweakerAPI.apply((IAction)new removeSpawnAction(registryName, creatureType, names));
    }

    @ZenMethod
    public static void removeSpawn(String registryName, String creatureType) {
        CraftTweakerAPI.apply((IAction)new removeSpawnAction(registryName, creatureType));
    }

    private static class removeSpawnAction
    implements IAction {
        private String registryName;
        private String creaturetype;
        private String[] names;
        boolean all = false;

        public removeSpawnAction(String registryName, String creatureType, String[] names) {
            this.registryName = registryName;
            this.creaturetype = creatureType;
            this.names = names;
        }

        public removeSpawnAction(String registryName, String creatureType) {
            this.registryName = registryName;
            this.creaturetype = creatureType;
            this.names = null;
            this.all = true;
        }

        public void apply() {
            if (!this.all) {
                SpawnTableTweakerMC.removeSpawn(this.registryName, this.creaturetype, this.names);
            } else {
                SpawnTableTweakerMC.removeSpawnAllBiomes(this.registryName, this.creaturetype);
            }
        }

        public String describe() {
            return "Removing Spawns for " + this.registryName + " from " + (this.all ? "all" : "passed") + " biomes";
        }
    }

    private static class addSpawnAction
    implements IAction {
        private String registryName;
        private int weight;
        private int min;
        private int max;
        private String creaturetype;
        private String[] names;
        private MODE mode;

        public addSpawnAction(String registryName, int weight, int min, int max, String creatureType, String[] names, MODE mode) {
            this.registryName = registryName;
            this.weight = weight;
            this.min = min;
            this.max = max;
            this.creaturetype = creatureType;
            this.names = names;
            this.mode = mode;
        }

        public void apply() {
            switch (this.mode) {
                case NAMES: {
                    SpawnTableTweakerMC.addSpawn(this.registryName, this.weight, this.min, this.max, this.creaturetype, this.names);
                    break;
                }
                case TAG_WHITELIST: {
                    SpawnTableTweakerMC.addSpawnToTags(this.registryName, this.weight, this.min, this.max, this.creaturetype, this.names);
                    break;
                }
                case TAG_BLACKLIST: {
                    SpawnTableTweakerMC.addSpawnToTagsBlacklist(this.registryName, this.weight, this.min, this.max, this.creaturetype, this.names);
                }
            }
        }

        public String describe() {
            return "Adding Spawns for " + this.registryName + " with: " + (Object)((Object)this.mode);
        }
    }

    private static enum MODE {
        NAMES("biome names"),
        TAG_WHITELIST("biome tag whitelist"),
        TAG_BLACKLIST("biome tag blacklist");

        private String name;

        private MODE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

