/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URI;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static final String SELECT = "\u00a7";
    private static DecimalFormat energyValue = new DecimalFormat("###,###,###,###,###");

    public static String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (value < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1000000000L) {
            return String.valueOf((double)Math.round(value / 1000L) / 1000.0) + "M";
        }
        if (value < 1000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000L) / 1000.0) + "G";
        }
        if (value < 1000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000L) / 1000.0) + "T";
        }
        if (value < 1000000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000000L) / 1000.0) + "P";
        }
        if (value <= Long.MAX_VALUE) {
            return String.valueOf((double)Math.round(value / 1000000000000000L) / 1000.0) + "E";
        }
        return "Something is very broken!!!!";
    }

    public static String addCommas(int value) {
        return energyValue.format(value);
    }

    public static String addCommas(long value) {
        return energyValue.format(value);
    }

    public static double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getDistanceAtoB(Vec3D pos1, Vec3D pos2) {
        return Utils.getDistanceAtoB(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static boolean inRangeSphere(BlockPos posA, BlockPos posB, int range) {
        if (Math.abs(posA.func_177958_n() - posB.func_177958_n()) > range || Math.abs(posA.func_177956_o() - posB.func_177956_o()) > range || Math.abs(posA.func_177952_p() - posB.func_177952_p()) > range) {
            return false;
        }
        return Utils.getDistanceSq(posA.func_177958_n(), posA.func_177956_o(), posA.func_177952_p(), posB.func_177958_n(), posB.func_177956_o(), posB.func_177952_p()) <= (double)(range * range);
    }

    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSq(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public static boolean isConnectedToDedicatedServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() == null;
    }

    public static int determineOrientation(int x, int y, int z, EntityLivingBase entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return 0;
            }
            if ((double)y - d0 > 0.0) {
                return 1;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public static double round(double number, double multiplier) {
        return (double)Math.round(number * multiplier) / multiplier;
    }

    public static int getNearestMultiple(int number, int multiple) {
        int result = number;
        if (number < 0) {
            result *= -1;
        }
        if (result % multiple == 0) {
            return number;
        }
        result = result % multiple < multiple / 2 ? (result -= result % multiple) : (result += multiple - result % multiple);
        if (number < 0) {
            result *= -1;
        }
        return result;
    }

    public static int toInt(double d) {
        return (int)d;
    }

    public static int parseInt(String s) {
        return Utils.parseInt(s, true);
    }

    public static int parseInt(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            if (catchException) {
                return 0;
            }
            throw e;
        }
    }

    public static double parseDouble(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            if (catchException) {
                return 0.0;
            }
            throw e;
        }
    }

    public static double parseDouble(String s) {
        return Utils.parseDouble(s, true);
    }

    public static int parseHex(String s) {
        return Utils.parseHex(s, true);
    }

    public static int parseHex(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        if (catchException) {
            try {
                return (int)Long.parseLong(s, 16);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return (int)Long.parseLong(s, 16);
    }

    public static double map(double valueIn, double inMin, double inMax, double outMin, double outMax) {
        return (valueIn - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static boolean validInteger(String value) {
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean validDouble(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static EntityPlayer getClosestPlayer(World world, double posX, double posY, double posZ, double distance) {
        return Utils.getClosestPlayer(world, posX, posY, posZ, distance, true);
    }

    @Nullable
    public static EntityPlayer getClosestPlayer(World world, double posX, double posY, double posZ, double distance, boolean includeCreative) {
        return Utils.getClosestPlayer(world, posX, posY, posZ, distance, includeCreative, false);
    }

    @Nullable
    public static EntityPlayer getClosestPlayer(World world, double posX, double posY, double posZ, double distance, boolean includeCreative, boolean includeSpectators) {
        double d0 = -1.0;
        EntityPlayer closestPlayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            if (player.func_184812_l_() && !includeCreative || player.func_175149_v() && !includeSpectators) continue;
            double d1 = player.func_70092_e(posX, posY, posZ);
            if (!(distance < 0.0) && !(d1 < distance * distance) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    public static boolean checkClassInstanceOf(Class clazz, Class instanceOfThis) {
        if (clazz == null || instanceOfThis == null) {
            return clazz == null && instanceOfThis == null;
        }
        return instanceOfThis.isAssignableFrom(clazz);
    }

    public static String trimString(String input, int length, String trimExtension) {
        if (input.length() <= length) {
            return input;
        }
        return input.substring(0, length) + trimExtension;
    }

    public static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static void setClipboardString(String copyText) {
        if (!StringUtils.isEmpty((CharSequence)copyText)) {
            try {
                StringSelection stringselection = new StringSelection(copyText);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            LogHelperBC.error("Couldn't open link: {}", throwable == null ? "<UNKNOWN>" : throwable.getMessage());
        }
    }
}

