/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.HAlign;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.Minecraft;

public class MarkerElement
extends MDElementBase<MarkerElement> {
    private Type type;

    public MarkerElement(Type type) {
        this.type = type;
    }

    public MarkerElement(int spacerWidth, int spacerHeight) {
        this.type = Type.SPACER;
        this.setSize(spacerWidth, spacerHeight);
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        switch (this.type) {
            case NEW_LINE: {
                this.setPos(layout.getCaretX(), layout.getCaretY());
                layout.newLine(lineElement.isEmpty() ? 8 : 0);
                break;
            }
            case SPACER: {
                Point pos = layout.nextElementPos(this.xSize(), this.ySize());
                this.setPos(pos.x, pos.y);
            }
        }
    }

    public static boolean isNewLine(MDElementBase element) {
        return element instanceof MarkerElement && ((MarkerElement)element).type == Type.NEW_LINE;
    }

    public boolean isAlign() {
        return this.type == Type.ALIGN_LEFT || this.type == Type.ALIGN_CENTER || this.type == Type.ALIGN_RIGHT;
    }

    public HAlign getAlign() {
        return this.type == Type.ALIGN_LEFT ? HAlign.LEFT : (this.type == Type.ALIGN_CENTER ? HAlign.CENTER : HAlign.RIGHT);
    }

    public Type getType() {
        return this.type;
    }

    public static MarkerElement forAlignment(HAlign align) {
        return new MarkerElement(align == HAlign.LEFT ? Type.ALIGN_LEFT : (align == HAlign.CENTER ? Type.ALIGN_CENTER : Type.ALIGN_RIGHT));
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    public static enum Type {
        NEW_LINE,
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT,
        SPACER;

    }
}

