/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.botanicbonsai.block;

import com.latmod.mods.botanicbonsai.BotanicBonsaiConfig;
import com.latmod.mods.botanicbonsai.block.TileBotanicBonsaiPot;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.dave.bonsaitrees.tile.TileBonsaiPot;
import vazkii.botania.api.mana.IManaReceiver;

public class TileBonsaiPotManager
extends TileEntity
implements ITickable,
IManaReceiver {
    public int mana = 0;
    public int timer;

    public TileBonsaiPotManager() {
        this.timer = BotanicBonsaiConfig.general.manager_update_ticks;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.mana > 0) {
            nbt.func_74768_a("mana", this.mana);
        }
        if (this.timer > 0) {
            nbt.func_74777_a("timer", (short)this.timer);
        }
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.mana = nbt.func_74762_e("mana");
        this.timer = nbt.func_74765_d("timer");
        super.func_145839_a(nbt);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.timer;
        if ((long)this.timer <= 0L) {
            this.timer = BotanicBonsaiConfig.general.manager_update_ticks;
            ArrayList<TileBonsaiPot> tiles = new ArrayList<TileBonsaiPot>();
            int botanic = 0;
            int r = BotanicBonsaiConfig.general.manager_radius;
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    TileEntity t = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + z));
                    if (!(t instanceof TileBonsaiPot) || !((TileBonsaiPot)t).hasSapling() || !(t instanceof TileBotanicBonsaiPot) && !((TileBonsaiPot)t).isHarvestable()) continue;
                    tiles.add((TileBonsaiPot)t);
                    if (!(t instanceof TileBotanicBonsaiPot)) continue;
                    ++botanic;
                }
            }
            if (botanic > 0 && this.mana >= BotanicBonsaiConfig.general.mana_per_boost) {
                for (TileBonsaiPot tile : tiles) {
                    if (!(tile instanceof TileBotanicBonsaiPot)) continue;
                    tile.boostProgress();
                    this.mana -= BotanicBonsaiConfig.general.mana_per_boost;
                    this.field_145850_b.func_175718_b(2005, tile.func_174877_v(), 0);
                    if (this.mana >= BotanicBonsaiConfig.general.mana_per_boost) continue;
                    break;
                }
            }
            IItemHandler handler = null;
            boolean foundHandler = false;
            for (TileBonsaiPot tile : tiles) {
                if (!tile.isHarvestable()) continue;
                if (!foundHandler) {
                    Object facing;
                    TileEntity tileEntity;
                    foundHandler = true;
                    EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
                    int n = enumFacingArray.length;
                    for (int i = 0; i < n && ((tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a((EnumFacing)(facing = enumFacingArray[i])))) == null || (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) == null); ++i) {
                    }
                }
                if (handler != null) {
                    for (ItemStack stack : tile.getRandomizedDrops()) {
                        for (int i = 0; i < handler.getSlots() && !(stack = handler.insertItem(i, stack, false)).func_190926_b(); ++i) {
                        }
                    }
                }
                tile.setSapling(tile.getSapling());
            }
        }
    }

    public boolean isFull() {
        return this.mana >= BotanicBonsaiConfig.general.manager_mana_capacity;
    }

    public void recieveMana(int i) {
        this.mana += i;
    }

    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }

    public int getCurrentMana() {
        return this.mana;
    }
}

