/*
 * Decompiled with CFR 0.152.
 */
package openmods.integration.modules;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class ComputerCraftUtils {
    private static final Container DUMMY_CONTAINER = new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    };

    public static Object[] wrap(Object ... args) {
        return args;
    }

    protected static IRecipe findTurtleUpgradeRecipe() {
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!recipe.getClass().getSimpleName().equals("TurtleUpgradeRecipe")) continue;
            return recipe;
        }
        return null;
    }

    public static void addUpgradedTurtles(List<ItemStack> result, ItemStack upgradeItem) {
        IRecipe recipe = ComputerCraftUtils.findTurtleUpgradeRecipe();
        if (recipe != null) {
            ComputerCraftUtils.addTurtlesForUpgrade(result, recipe, upgradeItem);
        }
    }

    private static void addTurtlesForUpgrade(List<ItemStack> result, IRecipe recipe, ItemStack upgrade) {
        if (Turtles.normalTurtle != null) {
            ComputerCraftUtils.addTurtlesForUpgrade(result, recipe, Turtles.normalTurtle, upgrade);
        }
        if (Turtles.advancedTurtle != null) {
            ComputerCraftUtils.addTurtlesForUpgrade(result, recipe, Turtles.advancedTurtle, upgrade);
        }
    }

    private static void addTurtlesForUpgrade(List<ItemStack> result, IRecipe recipe, Item turtle, ItemStack upgrade) {
        ItemStack turtleStack = new ItemStack(turtle);
        ComputerCraftUtils.addTurtleForUpgrade(result, recipe, turtleStack, ItemStack.field_190927_a, upgrade);
        ComputerCraftUtils.addTurtleForUpgrade(result, recipe, turtleStack, new ItemStack(Blocks.field_150462_ai), upgrade);
        ComputerCraftUtils.addTurtleForUpgrade(result, recipe, turtleStack, new ItemStack(Items.field_151048_u), upgrade);
        ComputerCraftUtils.addTurtleForUpgrade(result, recipe, turtleStack, new ItemStack(Items.field_151047_v), upgrade);
        ComputerCraftUtils.addTurtleForUpgrade(result, recipe, turtleStack, new ItemStack(Items.field_151046_w), upgrade);
        ComputerCraftUtils.addTurtleForUpgrade(result, recipe, turtleStack, new ItemStack(Items.field_151056_x), upgrade);
        ComputerCraftUtils.addTurtleForUpgrade(result, recipe, turtleStack, new ItemStack(Items.field_151012_L), upgrade);
    }

    private static void addTurtleForUpgrade(List<ItemStack> result, IRecipe recipe, ItemStack turtle, ItemStack left, ItemStack right) {
        InventoryCrafting inv = new InventoryCrafting(DUMMY_CONTAINER, 3, 3);
        inv.func_70299_a(0, left);
        inv.func_70299_a(1, turtle);
        inv.func_70299_a(2, right);
        ItemStack upgradedTurtle = recipe.func_77572_b(inv);
        if (upgradedTurtle != null) {
            result.add(upgradedTurtle);
        }
    }

    @GameRegistry.ObjectHolder(value="ComputerCraft")
    private static class Turtles {
        @GameRegistry.ObjectHolder(value="CC-TurtleExpanded")
        public static Item normalTurtle;
        @GameRegistry.ObjectHolder(value="CC-TurtleAdvanced")
        public static Item advancedTurtle;

        private Turtles() {
        }
    }
}

