/*
 * Decompiled with CFR 0.152.
 */
package lykrast.glassential;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lykrast.glassential.BlockCustomGlass;
import lykrast.glassential.BlockEtherealGlass;
import lykrast.glassential.GlassentialConfig;
import lykrast.glassential.ItemGlassCutter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="glassential")
public class ModContent {
    public static Block clear;
    public static Block light;
    public static Block redstone;
    public static Block dark;
    public static Block ghostly;
    public static Block ethereal;
    public static Block etherealReverse;
    public static Item glassCutterIron;
    private static List<Item> itemBlocks;

    private static Block registerBlock(IForgeRegistry<Block> reg, Block block, String name, CreativeTabs tab) {
        block.setRegistryName(name);
        block.func_149663_c("glassential." + name);
        if (tab != null) {
            block.func_149647_a(tab);
        }
        reg.register((IForgeRegistryEntry)block);
        ItemBlock item = new ItemBlock(block);
        item.setRegistryName(block.getRegistryName());
        itemBlocks.add((Item)item);
        return block;
    }

    public static Item registerItem(IForgeRegistry<Item> reg, Item item, String name, CreativeTabs tab) {
        item.setRegistryName(name);
        item.func_77655_b("glassential." + name);
        if (tab != null) {
            item.func_77637_a(tab);
        }
        reg.register((IForgeRegistryEntry)item);
        return item;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        itemBlocks = new ArrayList<Item>();
        if (GlassentialConfig.clear) {
            clear = ModContent.registerBlock((IForgeRegistry<Block>)registry, (Block)new BlockCustomGlass(), "glass_clear", CreativeTabs.field_78030_b);
        }
        if (GlassentialConfig.light) {
            light = ModContent.registerBlock((IForgeRegistry<Block>)registry, new BlockCustomGlass().func_149715_a(1.0f), "glass_light", CreativeTabs.field_78030_b);
        }
        if (GlassentialConfig.redstone) {
            redstone = ModContent.registerBlock((IForgeRegistry<Block>)registry, (Block)new BlockCustomGlass(){

                public boolean func_149744_f(IBlockState state) {
                    return true;
                }

                public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                    return 15;
                }
            }, "glass_redstone", CreativeTabs.field_78028_d);
        }
        if (GlassentialConfig.dark) {
            dark = ModContent.registerBlock((IForgeRegistry<Block>)registry, new BlockCustomGlass().func_149713_g(255), "glass_dark", CreativeTabs.field_78030_b);
        }
        if (GlassentialConfig.ghostly) {
            ghostly = ModContent.registerBlock((IForgeRegistry<Block>)registry, (Block)new BlockCustomGlass(){

                public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
                }
            }, "glass_ghostly", CreativeTabs.field_78030_b);
        }
        if (GlassentialConfig.ethereal) {
            ethereal = ModContent.registerBlock((IForgeRegistry<Block>)registry, (Block)new BlockEtherealGlass(false), "glass_ethereal", CreativeTabs.field_78030_b);
        }
        if (GlassentialConfig.etherealReverse) {
            etherealReverse = ModContent.registerBlock((IForgeRegistry<Block>)registry, (Block)new BlockEtherealGlass(true), "glass_ethereal_reverse", CreativeTabs.field_78030_b);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry reg = event.getRegistry();
        for (Item i : itemBlocks) {
            reg.register((IForgeRegistryEntry)i);
        }
        if (GlassentialConfig.glassCutterIron) {
            glassCutterIron = ModContent.registerItem((IForgeRegistry<Item>)reg, new ItemGlassCutter(238), "glass_cutter_iron", CreativeTabs.field_78040_i);
        }
        ModContent.registerOreDict();
    }

    private static void registerOreDict() {
        if (GlassentialConfig.clear) {
            OreDictionary.registerOre((String)"blockGlass", (Block)clear);
        }
        if (GlassentialConfig.light) {
            OreDictionary.registerOre((String)"blockGlass", (Block)light);
        }
        if (GlassentialConfig.redstone) {
            OreDictionary.registerOre((String)"blockGlass", (Block)redstone);
        }
        if (GlassentialConfig.dark) {
            OreDictionary.registerOre((String)"blockGlass", (Block)dark);
        }
        if (GlassentialConfig.ghostly) {
            OreDictionary.registerOre((String)"blockGlass", (Block)ghostly);
        }
        if (GlassentialConfig.ethereal) {
            OreDictionary.registerOre((String)"blockGlass", (Block)ethereal);
        }
        if (GlassentialConfig.etherealReverse) {
            OreDictionary.registerOre((String)"blockGlass", (Block)etherealReverse);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (GlassentialConfig.clear) {
            GameRegistry.addSmelting((Block)Blocks.field_150359_w, (ItemStack)new ItemStack(clear), (float)0.1f);
        }
    }

    private static void initModel(Block b) {
        ModContent.initModel(Item.func_150898_a((Block)b));
    }

    private static void initModel(Item i) {
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation(i.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent evt) {
        if (GlassentialConfig.clear) {
            ModContent.initModel(clear);
        }
        if (GlassentialConfig.light) {
            ModContent.initModel(light);
        }
        if (GlassentialConfig.redstone) {
            ModContent.initModel(redstone);
        }
        if (GlassentialConfig.dark) {
            ModContent.initModel(dark);
        }
        if (GlassentialConfig.ghostly) {
            ModContent.initModel(ghostly);
        }
        if (GlassentialConfig.ethereal) {
            ModContent.initModel(ethereal);
        }
        if (GlassentialConfig.etherealReverse) {
            ModContent.initModel(etherealReverse);
        }
        for (Item i : itemBlocks) {
            ModContent.initModel(i);
        }
        itemBlocks = null;
        if (GlassentialConfig.glassCutterIron) {
            ModContent.initModel(glassCutterIron);
        }
    }
}

