/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons.net;

import alexanders.mods.auraddons.Auraddons;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ParticlePacket
implements IMessage {
    private Type type = Type.SHOCK_WAVE;
    private BlockPos pos = BlockPos.field_177992_a;
    private BlockPos endPos = BlockPos.field_177992_a;
    private float speed;
    private int color;
    private float scale;

    public ParticlePacket(Type type, BlockPos pos) {
        this.type = type;
        this.pos = pos;
    }

    public ParticlePacket(BlockPos startPos, BlockPos endPos, float speed, int color, float scale) {
        this.type = Type.PARTICLE_STREAM;
        this.pos = startPos;
        this.endPos = endPos;
        this.speed = speed;
        this.color = color;
        this.scale = scale;
    }

    public ParticlePacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.type = Type.fromIndex(buf.readInt());
        if (this.type == Type.PARTICLE_STREAM) {
            this.endPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.type.ordinal());
        if (this.type == Type.PARTICLE_STREAM) {
            buf.writeInt(this.endPos.func_177958_n());
            buf.writeInt(this.endPos.func_177956_o());
            buf.writeInt(this.endPos.func_177952_p());
            buf.writeFloat(this.speed);
            buf.writeInt(this.color);
            buf.writeFloat(this.scale);
        }
    }

    public static class Handler
    implements IMessageHandler<ParticlePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ParticlePacket message, MessageContext ctx) {
            Auraddons.proxy.runLater(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world != null) {
                    switch (message.type) {
                        case SHOCK_WAVE: {
                            for (int i = 0; i < 360; i += 2) {
                                double rad = Math.toRadians(i);
                                NaturesAuraAPI.instance().spawnMagicParticle((double)((float)message.pos.func_177958_n() + 0.5f), (double)((float)message.pos.func_177956_o() + 0.01f), (double)((float)message.pos.func_177952_p() + 0.5f), (double)((float)Math.sin(rad) * 0.65f), 0.0, (double)((float)Math.cos(rad) * 0.65f), 9509639, 3.0f, 10, 0.0f, false, true);
                            }
                            break;
                        }
                        case PARTICLE_STREAM: {
                            NaturesAuraAPI.instance().spawnParticleStream((float)message.pos.func_177958_n(), (float)message.pos.func_177956_o(), (float)message.pos.func_177952_p(), (float)message.endPos.func_177958_n(), (float)message.endPos.func_177956_o(), (float)message.endPos.func_177952_p(), message.speed, message.color, message.scale);
                            break;
                        }
                        case FREEZE: {
                            for (int i = world.field_73012_v.nextInt(20) + 20; i >= 0; --i) {
                                float x;
                                boolean side = world.field_73012_v.nextBoolean();
                                float f = side ? world.field_73012_v.nextFloat() : (x = world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                                float z = !side ? world.field_73012_v.nextFloat() : (world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                                NaturesAuraAPI.instance().spawnMagicParticle((double)((float)message.pos.func_177958_n() + x), (double)((float)message.pos.func_177956_o() + 0.1f + world.field_73012_v.nextFloat() * 0.98f), (double)((float)message.pos.func_177952_p() + z), 0.0, 0.0, 0.0, 12379135, world.field_73012_v.nextFloat() + 1.0f, 50, 0.0f, true, true);
                            }
                            break;
                        }
                    }
                }
            });
            return null;
        }
    }

    public static enum Type {
        SHOCK_WAVE,
        PARTICLE_STREAM,
        FREEZE;


        public static Type fromIndex(int index) {
            if (index < 0 || index >= Type.values().length) {
                Auraddons.logger.error("Received invalid particle index: {}", (Object)index);
                return Type.values()[0];
            }
            return Type.values()[index];
        }
    }
}

