/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons.net;

import alexanders.mods.auraddons.Auraddons;
import alexanders.mods.auraddons.block.tile.TileAuraTransporter;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConnectionPacket
implements IMessage {
    private static final long NULL_VALUE = -68719476737L;
    private BlockPos pos;
    private BlockPos other;

    public ConnectionPacket() {
    }

    public ConnectionPacket(BlockPos pos, BlockPos other) {
        this.pos = pos;
        this.other = other;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        long val = buf.readLong();
        if (val != -68719476737L) {
            this.other = BlockPos.func_177969_a((long)val);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        if (this.other == null) {
            buf.writeLong(-68719476737L);
        } else {
            long val = this.other.func_177986_g();
            buf.writeLong(val);
            if (val == -68719476737L) {
                Auraddons.logger.error("Mod Incompatibility?! Can't connect a transporter at block position -1, -1025, -1");
            }
        }
    }

    public static class Handler
    implements IMessageHandler<ConnectionPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ConnectionPacket message, MessageContext ctx) {
            Auraddons.proxy.runLater(() -> {
                TileEntity te;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world != null && (te = world.func_175625_s(message.pos)) instanceof TileAuraTransporter) {
                    ((TileAuraTransporter)te).other = message.other;
                }
            });
            return null;
        }
    }
}

