/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons.block.tile;

import alexanders.mods.auraddons.Auraddons;
import alexanders.mods.auraddons.init.ModConfig;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TileRainbowBeacon
extends TileEntity
implements ITickable {
    private static boolean reflectionFail;
    public float[] colorMultiplier = new float[]{-1.0f, -1.0f, -1.0f};
    private float hue = 0.0f;

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 20L == 19L) {
            TileEntity te;
            this.field_145850_b.field_72984_F.func_194340_a(() -> "RainbowBeaconUpdate");
            this.hue = (this.hue + 1.0f) % 360.0f;
            this.setHSV(this.hue, 1.0f, 1.0f);
            if (ModConfig.general.smoothRainbowBeacon && !reflectionFail && this.field_145850_b.func_82737_E() % 80L != 79L && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof TileEntityBeacon) {
                try {
                    ReflectionHelper.findMethod(TileEntityBeacon.class, (String)"updateSegmentColors", (String)"func_146003_y", (Class[])new Class[0]).invoke((Object)te, new Object[0]);
                }
                catch (ReflectionHelper.UnableToFindMethodException e) {
                    reflectionFail = true;
                    Auraddons.logger.error("Unable to find TileEntityBeacon#updateSegmentColors with obf name func_146003_y. Auraddons may not be fully compatible with this version of minecraft");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            this.field_145850_b.field_72984_F.func_76319_b();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.hue = compound.func_74760_g("hue");
        this.setHSV(this.hue, 1.0f, 1.0f);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("hue", this.hue);
        return compound;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound.func_74776_a("hue", this.hue);
        return compound;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.hue = tag.func_74760_g("hue");
        this.setHSV(this.hue, 1.0f, 1.0f);
    }

    private void setHSV(float hue, float saturation, float value) {
        float c = value * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = value - c;
        if (hue < 60.0f) {
            this.colorMultiplier[0] = c;
            this.colorMultiplier[1] = x;
            this.colorMultiplier[2] = 0.0f;
        } else if (hue < 120.0f) {
            this.colorMultiplier[0] = x;
            this.colorMultiplier[1] = c;
            this.colorMultiplier[2] = 0.0f;
        } else if (hue < 180.0f) {
            this.colorMultiplier[0] = 0.0f;
            this.colorMultiplier[1] = c;
            this.colorMultiplier[2] = x;
        } else if (hue < 240.0f) {
            this.colorMultiplier[0] = 0.0f;
            this.colorMultiplier[1] = x;
            this.colorMultiplier[2] = c;
        } else if (hue < 300.0f) {
            this.colorMultiplier[0] = x;
            this.colorMultiplier[1] = 0.0f;
            this.colorMultiplier[2] = c;
        } else {
            this.colorMultiplier[0] = c;
            this.colorMultiplier[1] = 0.0f;
            this.colorMultiplier[2] = x;
        }
        this.colorMultiplier[0] = this.colorMultiplier[0] + m;
        this.colorMultiplier[1] = this.colorMultiplier[1] + m;
        this.colorMultiplier[2] = this.colorMultiplier[2] + m;
    }
}

