/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons.block.tile;

import alexanders.mods.auraddons.init.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="auraddons")
public class TilePotionEnhancer
extends TileEntity {
    public static final ArrayList<TilePotionEnhancer> listenerList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TilePotionEnhancer() {
        ArrayList<TilePotionEnhancer> arrayList = listenerList;
        synchronized (arrayList) {
            listenerList.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void handlePotionBrew(PotionBrewEvent.Post event) {
        NonNullList stacks = (NonNullList)ReflectionHelper.getPrivateValue(PotionBrewEvent.class, (Object)event, (String[])new String[]{"stacks"});
        ArrayList<TilePotionEnhancer> arrayList = listenerList;
        synchronized (arrayList) {
            for (TilePotionEnhancer te : listenerList) {
                te.enhancePotion((NonNullList<ItemStack>)stacks);
            }
        }
    }

    @SubscribeEvent
    public static void handlePotionDrink(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack;
        if (event.getEntity() instanceof EntityPlayer && (stack = event.getItem()).func_77973_b().getClass() == ItemPotion.class && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("auraddons__duration_enhanced")) {
            for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)stack)) {
                ((EntityPlayer)event.getEntity()).func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() * 2, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void handleTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b().getClass() == ItemPotion.class && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("auraddons__duration_enhanced")) {
            List toolTip = event.getToolTip();
            int duration = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)stack).get(0)).func_76459_b() / 10;
            for (int i = 0; i < toolTip.size(); ++i) {
                String t = (String)toolTip.get(i);
                if (!t.matches(".* \\([0-9]+:[0-9][0-9]\\)")) continue;
                event.getToolTip().set(i, t.replaceFirst("\\([0-9]+:[0-9][0-9]\\)", String.format("%s(%d:%d0)", TextFormatting.DARK_PURPLE, duration / 60, duration % 60)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_145843_s() {
        super.func_145843_s();
        ArrayList<TilePotionEnhancer> arrayList = listenerList;
        synchronized (arrayList) {
            listenerList.remove((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChunkUnload() {
        super.onChunkUnload();
        ArrayList<TilePotionEnhancer> arrayList = listenerList;
        synchronized (arrayList) {
            listenerList.remove((Object)this);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (te instanceof TileEntityBrewingStand) {
            return te.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (te instanceof TileEntityBrewingStand) {
            return (T)te.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    private boolean checkHash(int hash) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (te instanceof TileEntityBrewingStand) {
            return Objects.hashCode(ReflectionHelper.getPrivateValue(TileEntityBrewingStand.class, (Object)((TileEntityBrewingStand)te), (String[])new String[]{"field_145945_j", "brewingItemStacks"})) == hash;
        }
        return false;
    }

    public void enhancePotion(NonNullList<ItemStack> brewingItemStacks) {
        if (this.checkHash(Objects.hashCode(brewingItemStacks)) && brewingItemStacks != null) {
            for (int i = 0; i < 3; ++i) {
                List effects;
                ItemStack stack = (ItemStack)brewingItemStacks.get(i);
                if (stack.func_77973_b().getClass() != ItemPotion.class || (effects = PotionUtils.func_185189_a((ItemStack)stack)).size() != 1 || stack.func_77978_p() == null || stack.func_77978_p().func_74767_n("auraddons__duration_enhanced")) continue;
                stack.func_77978_p().func_74757_a("auraddons__duration_enhanced", true);
                if (stack.func_77978_p().func_150297_b("Lore", 9)) {
                    stack.func_77978_p().func_150295_c("Lore", 8).func_74742_a((NBTBase)new NBTTagString("Duration enhanced"));
                } else {
                    NBTTagList list = new NBTTagList();
                    list.func_74742_a((NBTBase)new NBTTagString("Duration enhanced"));
                    stack.func_77978_p().func_74782_a("Lore", (NBTBase)list);
                }
                BlockPos spot = IAuraChunk.getHighestSpot((World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)25, (BlockPos)this.field_174879_c);
                IAuraChunk.getAuraChunk((World)this.field_145850_b, (BlockPos)spot).drainAura(spot, ModConfig.aura.potionEnhancerCostPerLevel * (((PotionEffect)effects.get(0)).func_76458_c() + 1));
            }
        }
    }
}

